<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a page at an incorrect URL.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app = your application
 *
 * -------------------------------------------------------------------------
 */

    sendHeaderHTML    (   );
    sendStatus404     (   );
    sendHeaderExpires ( 0 );
    stopIfHead        (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en-US">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/reset.min.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/fonts.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">

        <meta name="robots" content="noindex">
        <title>
            Page not found / Shopping UI with Vue.js
        </title>
    </head>

    <body>
        <div class="wrapper">
            <div class="screen">
                <div class="app-bar">
                    &nbsp;
                </div>

                <h1 class="title">Page is not found!</h1>

                <div class="shop-items">
                    <div class="item">
                        <div class="item-block">
                            <p class="description">Oops, something went wrong! There is no such page on this site.</p>

                            <nav class="bottom-area hr">
                                <div class="price">&nbsp;</div>
                                <a class="button" href="<?php printSiteUrl ( ) ?>">
                                    <p>GO TO HOME</p>
                                </a>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>