<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the news card.
 *
 * -------------------------------------------------------------------------
 *
 * These system variables are available:
 *
 *     $params   = the current news                          ( see file    tiny.news.feed/Themes/default/news-list.tpl
 *                                                             or see file tiny.news.feed/Themes/default/snippets/list.tpl )
 *     $app      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $app )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

?>
<section class="card news <?php tinyPrintState($params) ?>">
    <?php                                               // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/body.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
            [                                           // . . for this pseudo publication
                'title' => $params['title'],            // . . . . a name
                'meta'  => $params['meta'],             // . . . . a short text
                'image' => $params['image']             // . . . . an image
            ]                                           //
        ]);                                             //
                                                        // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/more.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/more.tpl )
            $params                                     // . . for this publication
        ]);                                             //
    ?>
</section>
