<?php
/**
 * -------------------------------------------------------------------------
 *
 * Application constants.
 *
 * You can define any constants you need for modules in your application.
 * To do this, write the required constant below in this file. To avoid
 * naming conflicts, it is recommended that the constant names below begin
 * with some unique prefix, such as TINYFEED_.
 *
 * -------------------------------------------------------------------------
 *
 * How did this file run?
 *
 *     ├─> .htaccess
 *     └─> index.php
 *           ├─> tiny.news.feed/Config.php
 *           ├─> mimimi.core/Routines.php
 *           │
 *           ├─> [MAKE THE $app GLOBAL VARIABLE]
 *           │
 *           ├─> tiny.news.feed/Constants.php
 *           │                  │
 *           │                  ├─<─ constant TINYFEED_ON_DEMO_NOW
 *           │                  ├─<─ constant TINYFEED_ADMIN_IPS
 *           │                  ├─<─ constant TINYFEED_HTMLPAGE_LANGUAGE
 *           │                  ├─<─ constant TINYFEED_HOMEPAGE_TITLE
 *           │                  ├─<─ constant TINYFEED_HOMEPAGE_META
 *           │                  ├─<─ constant TINYFEED_HOMEPAGE_H1
 *           │                  ├─<─ constant TINYFEED_HOMEPAGE_BODY
 *           │                  ├─<─ constant TINYFEED_NEWSLIST_TITLE
 *           │                  ├─<─ constant TINYFEED_NEWSLIST_META
 *           │                  ├─<─ constant TINYFEED_NEWSLIST_H1
 *           │                  ├─<─ constant TINYFEED_NEWSADD_TITLE
 *           │                  ├─<─ constant TINYFEED_NEWSADD_META
 *           │                  ├─<─ constant TINYFEED_NEWSADD_H1
 *           │                  ├─<─ constant TINYFEED_NEWSDELETE_TITLE
 *           │                  ├─<─ constant TINYFEED_NEWSDELETE_META
 *           │                  ├─<─ constant TINYFEED_NEWSDELETE_H1
 *           │                  ├─<─ constant TINYFEED_NEWSEDIT_TITLE
 *           │                  ├─<─ constant TINYFEED_NEWSEDIT_META
 *           │                  ├─<─ constant TINYFEED_NEWSEDIT_H1
 *           │                  ├─<─ constant TINYFEED_SEARCHLIST_TITLE
 *           │                  ├─<─ constant TINYFEED_SEARCHLIST_META
 *           │                  ├─<─ constant TINYFEED_SEARCHLIST_H1
 *           │                  ├─<─ constant TINYFEED_ERROR404_TITLE
 *           │                  ├─<─ constant TINYFEED_ERROR404_META
 *           │                  ├─<─ constant TINYFEED_ERROR404_H1
 *           │                  ├─<─ constant TINYFEED_ERROR404_BODY
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BREADCRUMBS
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BREADCRUMBS_HOME
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BREADCRUMBS_LIST
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BREADCRUMBS_PAGE
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BREADCRUMBS_ADD
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BREADCRUMBS_DELETE
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BREADCRUMBS_EDIT
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BREADCRUMBS_ERROR
 *           │                  ├─<─ constant TINYFEED_INTERFACE_LOGO
 *           │                  ├─<─ constant TINYFEED_INTERFACE_COPYRIGHT
 *           │                  ├─<─ constant TINYFEED_INTERFACE_READMORE
 *           │                  ├─<─ constant TINYFEED_INTERFACE_ADD
 *           │                  ├─<─ constant TINYFEED_INTERFACE_DELETE
 *           │                  ├─<─ constant TINYFEED_INTERFACE_EDIT
 *           │                  ├─<─ constant TINYFEED_INTERFACE_LIST
 *           │                  ├─<─ constant TINYFEED_INTERFACE_IAMSURE
 *           │                  ├─<─ constant TINYFEED_INTERFACE_SUBMIT
 *           │                  ├─<─ constant TINYFEED_INTERFACE_CANCEL
 *           │                  ├─<─ constant TINYFEED_INTERFACE_PREV
 *           │                  ├─<─ constant TINYFEED_INTERFACE_NEXT
 *           │                  ├─<─ constant TINYFEED_INTERFACE_URL_LABEL
 *           │                  ├─<─ constant TINYFEED_INTERFACE_URL_REMARK
 *           │                  ├─<─ constant TINYFEED_INTERFACE_ENABLED_LABEL
 *           │                  ├─<─ constant TINYFEED_INTERFACE_TITLE_LABEL
 *           │                  ├─<─ constant TINYFEED_INTERFACE_TITLE_REMARK
 *           │                  ├─<─ constant TINYFEED_INTERFACE_META_LABEL
 *           │                  ├─<─ constant TINYFEED_INTERFACE_META_REMARK
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BODY_LABEL
 *           │                  ├─<─ constant TINYFEED_INTERFACE_BODY_REMARK
 *           │                  ├─<─ constant TINYFEED_INTERFACE_IMAGE_LABEL
 *           │                  ├─<─ constant TINYFEED_INTERFACE_IMAGE_REMARK
 *           │                  ├─<─ constant TINYFEED_INTERFACE_IMGFILE_LABEL
 *           │                  ├─<─ constant TINYFEED_INTERFACE_IMGFILE_REMARK
 *           │                  ├─<─ constant TINYFEED_ERROR_CONFIRM_SURE
 *           │                  ├─<─ constant TINYFEED_ERROR_ID_SPOOFING
 *           │                  ├─<─ constant TINYFEED_ERROR_EMPTY_NEWS
 *           │                  ├─<─ constant TINYFEED_ERROR_URL_CONFLICT
 *           │                  ├─<─ constant TINYFEED_ERROR_BAD_IMAGE
 *           │                  ├─<─ constant TINYFEED_ERROR_DEMO
 *           │                  ├─<─ constant TINYFEED_ERROR_ILLEGAL_METHOD
 *           │                  ├─<─ constant TINYFEED_ERROR_NO_ROUTER
 *           │                  └─<─ constant TINYFEED_ERROR_NO_THEMES
 *           │
 *           └─> [LAUNCH THE APPLICATION MODULE]
 *
 * The down-right arrows show the order in which app files are loaded and
 * their methods that are called when processing a request to the site.
 * The left-up arrows show some of constants that the corresponding file
 * exposes to other application modules.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

define('TINYFEED_ON_DEMO_NOW',           TRUE);
define('TINYFEED_ADMIN_IPS',             [ '127.0.0.1',
                                           '::1',
                                           'localhost' ]);

define('TINYFEED_HTMLPAGE_LANGUAGE',     'en-US');

define('TINYFEED_HOMEPAGE_TITLE',        'Home page / Tiny News Feed');
define('TINYFEED_HOMEPAGE_META',         'Are you looking for the latest web theme gems? We have one of them which was developed in November 2023. That theme is called the Tiny News Feed.');
define('TINYFEED_HOMEPAGE_H1',           'Hi everyone!');
define('TINYFEED_HOMEPAGE_BODY',         '<p><strong>It is the example</strong> of a small website that’s specifically geared up for messenger-style blogging. It based on the <code>MiMiMi</code><sup>framework</sup>, a beginner-friendly platform destined to develop lightweight websites.</p>' .
                                         '<details>' .
                                             '<summary>Want to know more?</summary>' .
                                             '<br>' .
                                             '<p>More precisely, Tiny News Feed is not just a website theme, but a full-fledged web application. It has some typical features built into the base, like:</p>' .
                                             '<ul>' .
                                                 '<li>a <u>home</u> page that displays the latest publications,</li>' .
                                                 '<li>a <a href="news">list</a> of news in historical order,</li>' .
                                                 '<li>a <a href="news/demo-posts/faq/how-to-get-current-page-url">single</a> page to read a news publication,</li>' .
                                                 '<li>a <a href="search?q=source+code" rel="nofollow">searching</a> page that displays the corresponding publications,</li>' .
                                                 '<li>an <a href="some-indefinite-vague-non-existent-abracadabra" rel="nofollow">Error</a><sub>404</sub> page to serve visits to non-existent pages,</li>' .
                                                 '<li>an XML <a href="news/sitemap" rel="nofollow">sitemap</a> intended for search robots,</li>' .
                                                 '<li>a <a href="robots.txt" rel="nofollow">robots.txt</a> document also intended for crawlers,</li>' .
                                                 '<li>and administrative pages to <a href="news/add" rel="nofollow">add</a>, <a href="news/demo-posts/faq/how-to-get-current-page-url/delete" rel="nofollow">delete</a>, or <a href="news/demo-posts/faq/how-to-get-current-page-url/edit" rel="nofollow">edit</a> your news.</li>' .
                                             '</ul>' .
                                             '<p><small>Any type of these pages is optional. You can delete their template files or modules to remove the related features from your website.</small></p>' .
                                             '<hr>' .
                                             '<h2>Also</h2>' .
                                             '<p>With this theme, you will get a website with very light and fast loading pages.</p>' .
                                             '<blockquote>' .
                                                 '<p>Its templatized HTML markup, CSS files, JavaScript files, PHP source code, and related modules or sub-templates are quite simple and easy to understand for a developer of any skill level.</p>' .
                                             '</blockquote>' .
                                             '<p>The theme author tried to make <code>Tiny News Feed</code> as elegant as possible, with just the right amount of functionality.</p>' .
                                         '</details>');

define('TINYFEED_NEWSLIST_TITLE',        'News list / Tiny News Feed / Page №');
define('TINYFEED_NEWSLIST_META',         'Read all the latest up-to-date news headlines and briefs in one place.');
define('TINYFEED_NEWSLIST_H1',           'All News History');

define('TINYFEED_NEWSADD_TITLE',         'Add News / Tiny News Feed');
define('TINYFEED_NEWSADD_META',          'Please complete the form below to add a new page to your website.');
define('TINYFEED_NEWSADD_H1',            'Add News');

define('TINYFEED_NEWSDELETE_TITLE',      'Delete News / Tiny News Feed');
define('TINYFEED_NEWSDELETE_META',       'Are you sure you want to remove this news from your website?');
define('TINYFEED_NEWSDELETE_H1',         'Delete This News');

define('TINYFEED_NEWSEDIT_TITLE',        'Edit News / Tiny News Feed');
define('TINYFEED_NEWSEDIT_META',         'Please correct the information in the form below in order to edit this page on your website.');
define('TINYFEED_NEWSEDIT_H1',           'Edit This News');

define('TINYFEED_SEARCHLIST_TITLE',      'Search results / Tiny News Feed / Page №');
define('TINYFEED_SEARCHLIST_META',       'Sorry, there are no results for this request. Please complete the search form in the header bar with a new keyword phrase (4 words maximum) to find related pages.');
define('TINYFEED_SEARCHLIST_H1',         'Searching For ');

define('TINYFEED_ERROR404_TITLE',        'Page not found / Tiny News Feed');
define('TINYFEED_ERROR404_META',         'Oops, something went wrong! There is no such page.');
define('TINYFEED_ERROR404_H1',           'Page is not found!');
define('TINYFEED_ERROR404_BODY',         '<p>Please check that the URL you entered is correct, or go to the website home page.</p>');

define('TINYFEED_INTERFACE_BREADCRUMBS', [ ''       => 'Home Page',
                                           'news'   => 'News List',
                                           'search' => 'Search',
                                           '*'      => 'Miscellaneous' ]);

define('TINYFEED_INTERFACE_BREADCRUMBS_HOME',   FALSE);
define('TINYFEED_INTERFACE_BREADCRUMBS_LIST',   'Page');
define('TINYFEED_INTERFACE_BREADCRUMBS_PAGE',   'Publication');
define('TINYFEED_INTERFACE_BREADCRUMBS_ADD',    'Adding');
define('TINYFEED_INTERFACE_BREADCRUMBS_DELETE', 'Deleting');
define('TINYFEED_INTERFACE_BREADCRUMBS_EDIT',   'Editing');
define('TINYFEED_INTERFACE_BREADCRUMBS_ERROR',  'Error');

define('TINYFEED_INTERFACE_LOGO',        'Tiny News Feed');
define('TINYFEED_INTERFACE_COPYRIGHT',   '© It\'s Demo site');
define('TINYFEED_INTERFACE_READMORE',    'Read More »');
define('TINYFEED_INTERFACE_ADD',         'Add To');
define('TINYFEED_INTERFACE_DELETE',      'Delete');
define('TINYFEED_INTERFACE_EDIT',        'Edit');
define('TINYFEED_INTERFACE_LIST',        'See All Of');
define('TINYFEED_INTERFACE_IAMSURE',     'Yes, I am sure');
define('TINYFEED_INTERFACE_SUBMIT',      'Send »');
define('TINYFEED_INTERFACE_CANCEL',      '× Cancel');
define('TINYFEED_INTERFACE_PREV',        '« Back');
define('TINYFEED_INTERFACE_NEXT',        'Oldest »');

define('TINYFEED_INTERFACE_URL_LABEL',      'Page URL:');
define('TINYFEED_INTERFACE_URL_REMARK',     'Leave this field blank if you want to automatically generate the page URL. In this case, it will consist of a random set of characters.');
define('TINYFEED_INTERFACE_ENABLED_LABEL',  'Visible For All');
define('TINYFEED_INTERFACE_TITLE_LABEL',    'Title:');
define('TINYFEED_INTERFACE_TITLE_REMARK',   'This field contains the name of the publication in listings. It is also the string of the page Title tag.');
define('TINYFEED_INTERFACE_META_LABEL',     'Short Text:');
define('TINYFEED_INTERFACE_META_REMARK',    'This field contains short introductory text that appears in publication listings and at the top of the publication page. It is also the string of the page Meta Description tag.');
define('TINYFEED_INTERFACE_BODY_LABEL',     'Full Text:');
define('TINYFEED_INTERFACE_BODY_REMARK',    'You can use valid HTML markup for this field. All HTML tag attributes will be removed for security reasons except attribute href="some-url" for tag <a> and attribute src="some-url" for tag <img>.');
define('TINYFEED_INTERFACE_IMAGE_LABEL',    'Image URL:');
define('TINYFEED_INTERFACE_IMAGE_REMARK',   'You should enter the image URL manually if your page needs to have an image with a specific file name. Otherwise, the image URL will be set to the name of the uploaded file. If you need an external image on your page, enter its absolute URL here and do not use the input field above to upload the image.');
define('TINYFEED_INTERFACE_IMGFILE_LABEL',  'Image to upload:');
define('TINYFEED_INTERFACE_IMGFILE_REMARK', 'The file length should not exceed 5 megabytes. File type: WEBP, JPEG, PNG, SVG, GIF or BMP.');

define('TINYFEED_ERROR_CONFIRM_SURE',    'Please confirm your wish by checking the "Yes, I am sure" box.');
define('TINYFEED_ERROR_ID_SPOOFING',     'Your request cannot be accepted because an attempt to spoof the ID field has been detected.');
define('TINYFEED_ERROR_EMPTY_NEWS',      'You must fill in all fields or at least one of these: title, short text, image URL, full text.');
define('TINYFEED_ERROR_URL_CONFLICT',    'The page URL you entered has been conflicted with another page.');
define('TINYFEED_ERROR_BAD_IMAGE',       'The uploaded image file must be in WEBP, JPEG, PNG, SVG, GIF or BMP format.');
define('TINYFEED_ERROR_DEMO',            'Everything is fine! However, this website did not save your changes because you are currently in demo mode. In this mode, any addition/change/deletion of pages is simply simulated to show you how it would work on a real site.');
define('TINYFEED_ERROR_ILLEGAL_METHOD',  'Unfortunately, only methods like HEAD, GET, and POST are allowed when accessing this website.');
define('TINYFEED_ERROR_NO_ROUTER',       'Critical error! This website does not have the required module ROUTER installed. If you are a site administrator, please install this module.');
define('TINYFEED_ERROR_NO_THEMES',       'Critical error! This website does not have the required module THEMES installed. If you are a site administrator, please install this module.');
