<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the tool buttons to edit a Static page.
 *
 * -------------------------------------------------------------------------
 *
 * Input parameters are:
 *
 *     $params = HTML content of this page.
 *
 * -------------------------------------------------------------------------
 */

    $url              = mimimiUri ( FALSE );
    $permission       = helperGetPermission ( $params );
    $allowConstructor = $permission == '' || $permission == 'constructor';
    $allowEditor      = $permission == '' || $permission == 'editor';

?>  <details class="tools">
        <summary>
            Editor Tools
        </summary>
        <div>
            <?php
                if ( $allowConstructor ) {
                    ?>
                    <a class="tool" href="<?php printSiteUrl ( ) ?>construct/<?php printValue ( $url ) ?>" rel="nofollow" title="Edit this page in the built-in Constructor">
                        Construct
                    </a>
                    <?php
                }

                if ( $allowEditor ) {
                    ?>
                    <a class="tool" href="<?php printSiteUrl ( ) ?>edit/<?php printValue ( $url ) ?>" rel="nofollow" title="Edit this page in the built-in HTML editor">
                        Edit
                    </a>

                    <a class="tool" href="<?php printSiteUrl ( ) ?>copy/<?php printValue ( $url ) ?>" rel="nofollow" title="Clone this page using the built-in HTML editor">
                        Copy
                    </a>
                    <?php
                }
            ?>

            <a class="tool" href="<?php printSiteUrl ( ) ?>markup/<?php printValue ( $url ) ?>" rel="nofollow" title="Edit this page as HTML code">
                Mark Up
            </a>

            <a class="tool" href="<?php printSiteUrl ( ) ?>upload/<?php printValue ( $url ) ?>" rel="nofollow" title="Upload a new content to this page">
                Upload
            </a>

            <a class="tool" href="<?php printSiteUrl ( ) ?>download/<?php printValue ( $url ) ?>" rel="nofollow" title="Download this page as a TPL file">
                Download
            </a>

            <a class="tool" href="<?php printSiteUrl ( ) ?>delete/<?php printValue ( $url ) ?>" rel="nofollow" title="Delete this page">
                Delete
            </a>
        </div>
    </details>
