<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering script tags for the built-in HTML editor.
 *
 * -------------------------------------------------------------------------
 */

    if ( ! helperIsConstructUrl ( )
    &&   ! helperIsMarkupUrl    ( ) ) {

        /**
         * -----------------------------------------------------------------
         *
         * First, we need to define a JavaScript constant of the same name.
         * Because this constant is used in "static.pages.only/Themes/js/editor.js"
         * file which will be loaded later.
         *
         * -----------------------------------------------------------------
         */

        ?>

        <script>
            const STATICPAGESONLY_CKEDITOR_KEY = '<?php printValue ( STATICPAGESONLY_CKEDITOR_KEY ) ?>';

            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Next, we also need to define one more JavaScript constant
                 * that contains a list of bbCodes. It is also used used in
                 * the "static.pages.only/Themes/js/editor.js" file.
                 *
                 * ---------------------------------------------------------
                 */
        
                $value = '';
                $list  = helperCollectBBcodes ( TRUE );
                foreach ( $list as $url ) {
                    $html = helperLoadBBcode (        $url );
                    $name = helperGetName    ( $html, $url );
                    if ( $value != '' ) $value .= ', ';
                    $value .= "'" . printValue ( $name, FALSE ) .
                              '|' . printValue ( $url,  FALSE ) .
                              "'";
                }
            ?>

            const STATICPAGESONLY_CKEDITOR_BBCODES = [ <?php echo $value ?> ];
        </script>

        <?php
            /**
             * -------------------------------------------------------------
             *
             * Next we need to import the free scripts.
             *
             * -------------------------------------------------------------
             */
        ?>

        <script type="importmap">
            {
                "imports": {
                    "ckeditor5":  "<?php printThemeUrl ( ) ?>js/ckeditor5/ckeditor5.js",
                    "ckeditor5/": "<?php printThemeUrl ( ) ?>js/ckeditor5/"
                }
            }
        </script>

        <?php
            /**
             * -------------------------------------------------------------
             *
             * We also need to import paid plugins if you had a commercial
             * license key.
             *
             * -------------------------------------------------------------
             */

            if ( STATICPAGESONLY_CKEDITOR_KEY != 'GPL' ) {
                ?>
                <script type="importmap">
                    {
                        "imports": {
                            "ckeditor5-premium-features":  "<?php printThemeUrl ( ) ?>js/ckeditor5-premium-features/ckeditor5-premium-features.js",
                            "ckeditor5-premium-features/": "<?php printThemeUrl ( ) ?>js/ckeditor5-premium-features/"
                        }
                    }
                </script>
                <?php
            }

            /**
             * -------------------------------------------------------------
             *
             * Next, we need to load the client-side scripts that serve the
             * built-in HTML editor.
             *
             * -------------------------------------------------------------
             *
             * Please note that processing of a script with the "type=module"
             * attribute is always deferred (will be executed after the page
             * has been parsed).
             *
             * -------------------------------------------------------------
             */

            ?>

            <script src="<?php printThemeUrl ( ) ?>js/editor.js" type="module"></script>

            <?php
    }
