<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering a "TEXTAREA" tag for the built-in constructor.
 *
 * -------------------------------------------------------------------------
 *
 * Input parameters are:
 *
 *     $params = A page entry that needs to be edited.
 *
 * -------------------------------------------------------------------------
 */

    if ( helperIsConstructUrl ( ) ) {
        ?>

        <details class="aside" open>
            <summary title="Show / Hide a list of blocks that can be dragged onto the construction area">
                Blocks
            </summary>

            <a class="tool" href="<?php printSiteUrl ( ) ?>fragments" title="Manage Fragment blocks" rel="nofollow" tabindex="-1">
                edit
            </a>

            <div>
                <?php
                    /**
                     * -----------------------------------------------------
                     *
                     * Collect all existing Fragment blocks and display them
                     * as a UL list.
                     *
                     * -----------------------------------------------------
                     */

                    $files = helperCollectFragments ( );
                    mimimiModule ([ 'snippets/list-fragments.tpl', TRUE, $files ]);
                ?>

                <button class="btn"
                        name="submit3"
                        type="submit"
                        title="Save the changes you made on this page"
                        onclick="getEditorContent ( this )">
                    Save
                </button>
                <a class="btn" href="<?php printSiteUrl ( ) ?>pages" title="Return to the list of existing pages">
                    Cancel
                </a>

                <p>Drag the block you are interested in to the page construction area. The insertion point will be highlighted there in <span style="color: var( --constructDropTargetColor )">this color</span> with a half-shadow indicating the insertion direction (above or below the highlighted place).</p>
                <p>The active block will be highlighted in <span style="color: var( --constructActiveBlockColor )">this color</span>. You can select another block by clicking on it with the mouse in the construction area. Or use the Shift+Up / Shift+Down keys to select a block using the keyboard.</p>
                <p>You can use the Ctrl+Delete key to remove the active block.</p>
                <p>You can use the Ctrl+Up / Ctrl+Down keys to move the active block in front of the block above it or after the block below it.</p>
                <p>You can use the Ctrl+Enter key to edit the active block as HTML code. Or just double click it with the mouse.</p>
                <p>Also you can use the Ctrl+MouseClick to edit a text that blinks <span style="animation: textHoverColor 1s infinite linear;">like this</span> when you move the mouse cursor over that text.</p>
            </div>

            <dialog class="modal-window">
                <label>
                    <span> Edit Block as HTML code: </span>
                    <textarea name="dummy[]"></textarea>
                </label>
                <button class="btn"
                        title="Accept the changes you made to this block"
                        onclick="updateConstructionBlock ( this )">
                    Update
                </button>
                <a class="btn" href="construct"
                               title="Close this dialog without making any changes"
                               onclick="closeModalWindow ( this )">
                    Cancel
                </a>
            </dialog>
        </details>

        <main class="left"><?php
            helperEchoEditableBody ( $params )
        ?></main>

        <input name="body" type="hidden" value="">

        <?php
    }
