/**
 * -------------------------------------------------------------------------
 *
 * The frontend scripts for the Upload SOMETHING page.
 *
 * -------------------------------------------------------------------------
 *
 * If you need some JavaScript logic on this page, it can be written below.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    import ( './login.js' );

    /**
     * ---------------------------------------------------------------------
     *
     * To generate a new bbCode URL.
     *
     * ---------------------------------------------------------------------
     */

    const generateBBcodeUrl = ( btn, len = 4, segments = 4 ) => {
        const label = btn.closest ( 'label' );
        if ( label ) {
            const input = label.querySelector ( 'input[type="text"]' );
            if ( input ) {
                let code,
                    char,
                    url = '';
                while ( segments > 0 ) {
                    for ( let i = 0; i < len; i++ ) {
                        code = 48 + Math.random ( ) * ( 10 + 26 );
                        if ( code > 58 ) code += 39;
                        char = String.fromCharCode ( code );
                        url += char;
                    }
                    segments--;
                    if ( segments ) url += '-';
                };
                input.value = url + '.tpl';
            }
        }
    };

    /**
     * ---------------------------------------------------------------------
     *
     * To generate a new Fragment URL.
     *
     * ---------------------------------------------------------------------
     */

    const generateFragmentUrl = ( btn, len = 4, segments = 4 ) => {
        generateBBcodeUrl ( btn, len, segments );
    };
