<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the Error 409 (Conflict) page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         (   );
    sendStatus409          (   );
    sendHeaderExpires      ( 0 );
    sendHeaderLastModified (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            Conflict
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="noindex, nofollow">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/error-409.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error"></aside>

            <main class="content">
                <div class="left">
                    <h1 class="title">
                        Conflict
                    </h1>
                    <p>Oops, this URL is already in use by another object, so the Add command is not allowed in this case.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>toc" title="View the list of existing pages">
                        Table of Contents
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <p>Please make sure the URL you provided does not conflict with any others, or go to the home page.</p>
                    </div>
                </div>
            </main>

            <footer class="footnote">
                <a href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                    Home
                </a>

                <a href="<?php printSiteUrl ( ) ?>credits" title="Gratitude to third party developers">
                    Credits
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/error-409.js"></script>
    </body>
</html>
