<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the Error 404 (Not Found) page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         (   );
    sendStatus404          (   );
    sendHeaderExpires      ( 0 );
    sendHeaderLastModified (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Is the current visitor an administrator? We get this boolean flag
     * exactly before generating the page content because the helperAmIAdmin()
     * routine algorithm implies sending server headers that can no longer
     * be sent if this routine is used inside content generation.
     *
     * ---------------------------------------------------------------------
     */

    $amIAdmin = helperAmIAdmin ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            Not Found
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="noindex, nofollow">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/error-404.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error"></aside>

            <main class="content">
                <div class="left">
                    <h1 class="title">
                        Page Not Found
                    </h1>
                    <p>Oops, something went wrong! There is no such page on this site.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>toc" title="View the list of existing pages">
                        Table of Contents
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <p>Please check that the URL you entered is correct, or go to the home page.</p>

                        <?php
                            if ( $amIAdmin ) {
                                $url = mimimiUri ( FALSE );

                                ?>
                                <p>Note also that you are already logged in, so you can create such a page right now.</p>
                                <a class="btn" href="<?php printSiteUrl ( ) ?>add/<?php printValue ( $url ) ?>" rel="nofollow" title="Create a new page with the current URL">
                                    Create Page
                                </a>

                                <?php
                            } else {
                                ?>
                                <p>Maybe you are an admin and want to create such a page? In that case, you need to log in first.</p>
                                <a class="btn" href="<?php printSiteUrl ( ) ?>login" rel="nofollow" title="Authorize as an administrator">
                                    Log In
                                </a>

                                <?php
                            }
                        ?>
                    </div>
                </div>
            </main>

            <footer class="footnote">
                <a href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                    Home
                </a>

                <a href="<?php printSiteUrl ( ) ?>credits" title="Gratitude to third party developers">
                    Credits
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/error-404.js"></script>
    </body>
</html>
