<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the Fragment Blocks page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         (   );
    sendStatus200          (   );
    sendHeaderExpires      ( 0 );
    sendHeaderLastModified (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            Fragment Blocks
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="noindex, nofollow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/fragments.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error"></aside>

            <main class="content list">
                <div class="left">
                    <h1 class="title">
                        Fragments
                    </h1>
                    <p>To add some construction features, this app provides the ability to edit the list of Fragment files.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                        Home Page
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <h2>Fragment Files</h2>
                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * Collect all existing Fragment blocks and
                             * display them as a UL list.
                             *
                             * ---------------------------------------------
                             */

                            $files = helperCollectFragments ( );
                            mimimiModule ([ 'snippets/list-fragments.tpl', $files ]);
                        ?>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>fragments/add" rel="nofollow" title="Add a new Fragment block">
                            Add New
                        </a>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>fragments/upload" rel="nofollow" title="Upload a new Fragment block">
                            Upload New
                        </a>

                        <br>
                        <br>
                        <h2>Do you know...</h2>
                        <p>Fragment is a marked-up block of HTML (may also contain local CSS and JavaScript right within the same block), similar to a snippet.</p>
                        <p>It is stored in a TPL file and is usually wrapped in a <code>&lt;header&gt;</code>, <code>&lt;section&gt;</code>, <code>&lt;aside&gt;</code>, <code>&lt;footer&gt;</code>, or other container tag. Please note that local CSS and JavaScript tags must also be wrapped in that container tag, otherwise they may be lost during intensive construction.</p>
                        <p>Such fragments can be used as building blocks in the built-in <a href="construct" rel="nofollow">Constructor</a> when editing a static page.</p>
                    </div>
                </div>
            </main>

            <footer class="footnote">
                <a class="tool" href="<?php printSiteUrl ( ) ?>pages" rel="nofollow" title="Manage pages">
                    Pages
                </a>

                <a class="tool" href="<?php printSiteUrl ( ) ?>styles" rel="nofollow" title="Manage page styles">
                    Styles
                </a>

                <a class="tool" href="<?php printSiteUrl ( ) ?>bbcodes" rel="nofollow" title="Manage bbCode blocks">
                    bbCodes
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/fragments.js"></script>
    </body>
</html>
