<?php
/**
 * -------------------------------------------------------------------------
 *
 * Сниппет: Сгенерировать карточку вакансии.
 *
 * -------------------------------------------------------------------------
 *
 * Входные параметры:
 *
 *     $app    = Указатель на объект Вашего приложения.
 *     $params = Данные от шаблона, вызвавшего этот сниппет.
 *               Представляют собой ассоциативный массив из таких элементов:
 *                   'row'        = Запись о выводимой вакансии.
 *                                  Структуру записи смотрите в методе onInstall() файла "repost.vacancies/Models/Vacancies/Vacancies.php".
 *                   'admintools' = TRUE, если вывести ещё и кнопки администратора.
 *
 * -------------------------------------------------------------------------
 */

?>  <section class="card vacancy">
        <?php
            if ( $params[ 'admintools' ] ) {
                mimimiModule ([ 'snippets/admintools.tpl', $params[ 'row' ] ]);
            }
            $row = $params[ 'row' ][ 'content' ];
        ?>
        <h2>
            <a class="silent" href="<?php printUrl ( $params[ 'row' ], 'vacancy_id' ) ?>" tabindex="-1">
                <?php printValue ( $row[ 'vacancyName' ] ) ?>
            </a>
        </h2>
        <ul class="report">
            <li>Город:         <?php                                      printValue ( $params[ 'row' ][ 'town' ]                   ) ?></li>
            <li>Организация:   <div class="html"><?php                    printValue ( $row[ 'fullCompanyName'          ]           ) ?></div></li>
            <li>Должность:     ├─> <?php                                  printValue ( $row[ 'vacancyName'              ]           ) ?></li>
            <?php
                $min = intval ( preg_replace ( '~\s~u', '', $row[ 'salaryMin' ] ) );
                $max = intval ( preg_replace ( '~\s~u', '', $row[ 'salaryMax' ] ) );
                $min = $min <= 0 ? $max
                                 : $min;
                $max = $max <= 0 ? $min
                                 : $max;
                $min = preg_replace ( '~(\d)(\d\d\d)$~u', '$1 $2', $min );
                $max = preg_replace ( '~(\d)(\d\d\d)$~u', '$1 $2', $max );
                if ( $min == $max ) {
                    ?>
                    <li>Зарплата:      │   └─> <div class="salary"><?php  printValue ( $min                                         ) ?> рублей</div></li>
                    <?php
                } else {
                    ?>
                    <li>Зарплата:      │   └─> <div class="salary">от <?php printValue ( $min                                       ) ?> до <?php printValue ( $max ) ?> рублей</div></li>
                    <?php
                }
            ?>
            <li>Бонус:         │       └─> <div class="if-present"><?php  printValue ( $row[ 'bonusType'                ]           ) ?></div></li>
            <li>Расписание:    └─> <?php                                  printValue ( $row[ 'workScheduleType'         ][ 'name' ] ) ?></li>
            <li>Тип:               ├─> <?php                              printValue ( $row[ 'busyType'                 ]           ) ?></li>
            <li>Начало дня:        │   ├─> <div class="if-present"><?php  printValue ( $row[ 'startWorking'             ]           ) ?></div></li>
            <li>Конец дня:         │   └─> <div class="if-present"><?php  printValue ( $row[ 'endWorking'               ]           ) ?></div></li>
            <li>Адрес:             └─> <div class="html"><?php            printValue ( $row[ 'fullAddress'              ]           ) ?></div></li>
            <li>                       └─> <div class="html if-present"><?php echo     $row[ 'vacancyAddressAdditionalInfo' ]         ?></div></li>
            <li>Опыт работы:   <div data-value="<?php                     printValue ( $row[ 'requiredExperience'       ]           ) ?>" class="experience"> год(а)</div></li>
            <li><hr>Детали:        <div class="html if-present"><?php     echo         $row[ 'additionalRequirements'   ]             ?></div></li>
            <li><hr>Образование:   <?php                                  printValue ( $row[ 'educationType'            ]           ) ?></li>
            <li>Специализация: └─> <div class="label-none"><?php          printValue ( $row[ 'educationSpeciality'      ]           ) ?></div></li>
            <li>Профессия:         └─> <?php                              printValue ( $row[ 'profession'               ]           ) ?></li>
            <li>Квалификация:          └─> <?php                          printValue ( $row[ 'qualification'            ]           ) ?></li>
            <li><hr>Документы:     <div class="if-present"><?php          printValue ( $row[ 'medicalDocument'          ][ 'text' ] ) ?></div></li>
            <li>Сертификаты:   <div class="html if-present"><?php         echo         $row[ 'requiredCertificates'     ]             ?></div></li>
            <?php
                if ( $row[ 'requiredDriveLicense' ] ) {
                    ?>
                    <li><hr>Нужны права:  <?php
                                              $count = count ( $row[ 'requiredDriveLicense' ] );
                                              $margin = $count > 1 ? '─┬─> '
                                                                   : ' ';
                                              foreach ( $row[ 'requiredDriveLicense' ] as $value ) {
                                                  printValue ( $margin . $value );
                                                  $count--;
                                                  if ( $count ) {
                                                      echo '</li><li>              ';
                                                  }
                                                  $margin = $count > 1 ? ' ├─> '
                                                                       : ' └─> ';
                                              }
                                          ?></li>
                    <?php
                }
            ?>
            <li><hr>Задачи:        <div class="html if-present"><?php     echo         $row[ 'positionResponsibilities' ]             ?></div></li>
            <li><hr>Требования:    <div class="html if-present"><?php     echo         $row[ 'positionRequirements'     ]             ?></div></li>
            <?php
                if ( $row[ 'skills' ] ) {
                    ?>
                    <li><hr>Качества:     <?php
                                              $count = count ( $row[ 'skills' ] );
                                              $margin = $count > 1 ? '─┬─> '
                                                                   : ' ';
                                              foreach ( $row[ 'skills' ] as $value ) {
                                                  echo $margin . '<div class="html">' . $value[ 'text' ] . '</div>';
                                                  $count--;
                                                  if ( $count ) {
                                                      echo '</li><li>              ';
                                                  }
                                                  $margin = $count > 1 ? ' ├─> '
                                                                       : ' └─> ';
                                              }
                                          ?></li>
                    <?php
                }
            ?>
            <li><hr>Контакты:      <?php         printValue ( $row[ 'contactPerson'       ]           ) ?></li>
            <?php
                $count = count ( $row[ 'contacts' ] );
                foreach ( $row[ 'contacts' ] as $key => $value ) {
                    $count--;
                    $margin = $count ? '               ├─> '
                                     : '               └─> ';
                    ?>
                    <li><?php printValue ( $margin . $key . ': ' . $value ) ?></li>
                    <?php
                }
            ?>
            <?php
                if ( $row[ 'benefits' ] ) {
                    ?>
                    <li><hr>Соц.пакет:    <?php
                                              $count = count ( $row[ 'benefits' ] );
                                              $margin = $count > 1 ? '─┬─> '
                                                                   : ' ';
                                              foreach ( $row[ 'benefits' ] as $value ) {
                                                  echo $margin . '<div class="html">' . $value . '</div>';
                                                  $count--;
                                                  if ( $count ) {
                                                      echo '</li><li>              ';
                                                  }
                                                  $margin = $count > 1 ? ' ├─> '
                                                                       : ' └─> ';
                                              }
                                          ?></li>
                    <li>Обучение:      <div data-value="<?php printValue ( $row[ 'trainingDays' ] ) ?>" class="training"> дней</div></li>
                    <?php
                }
                if ( $row[ 'socialProtected' ] ) {
                    ?>
                    <li><hr>Соц.защита:   <?php
                                              $count = count ( $row[ 'socialProtected' ] );
                                              $margin = $count > 1 ? '─┬─> '
                                                                   : ' ';
                                              foreach ( $row[ 'socialProtected' ] as $value ) {
                                                  printValue ( $margin . $value );
                                                  $count--;
                                                  if ( $count ) {
                                                      echo '</li><li>              ';
                                                  }
                                                  $margin = $count > 1 ? ' ├─> '
                                                                       : ' └─> ';
                                              }
                                          ?></li>
                    <li>Группа:        <div class="if-present"><?php printValue ( $row[ 'disabilityGroup' ][ 'name' ] ) ?></div></li>
                    <?php
                }
                $time  = substr ( $row[ 'publishedDate' ], 0, -3 );
                $day   = date ( 'd ',    $time );
                $month = date ( 'm',     $time ) - 1;
                $year  = date ( ' Y',    $time );
                $time  = date ( ', H:i', $time );
                $names = [ 'января'   ,
                           'февраля'  ,
                           'марта'    ,
                           'апреля'   ,
                           'мая'      ,
                           'июня'     ,
                           'июля'     ,
                           'августа'  ,
                           'сентября' ,
                           'октября'  ,
                           'ноября'   ,
                           'декабря'  ];
            ?>
            <li><hr>Опубликовано:  <?php printValue ( $day . $names[ $month ] . $year . $time ) ?></li>
            <li>Номер карты:   └─> <?php printValue ( $row[ 'vacancyNumber' ]                 ) ?></li>
            <?php
                if ( hasAdmin ( ) ) {
                    ?>
                    <li><a rel="nofollow noopener noreferrer" target="_blank" href="<?php      printValue ( $params[ 'row' ][ 'source_url'     ] ) ?>" class="btn secondary" tabindex="-1">Источник данных</a></li>
                    <li><hr>Через модуль:  Controllers ─> Parser ─> <div class="modname"><?php printValue ( $params[ 'row' ][ 'module'         ] ) ?></div></li>
                    <li>Тип данных:    │                        └─> vacancies</li>
                    <li>Когда парсили: ├─> <?php                                               printValue ( $params[ 'row' ][ 'created'        ] ) ?></li>
                    <li>Состояние:     │   └─> <?php                                           printValue ( $params[ 'row' ][ 'active'         ] ? 'Видна всем' : 'Скрыта' ) ?></li>
                    <li>Когда удалим:  ├─> <?php                                               printValue ( $params[ 'row' ][ 'killtime'       ] ) ?></li>
                    <li>Копия в ТГ:    ├─> <?php                                               printValue ( $params[ 'row' ][ 'tg_message_id'  ] ? 'Есть' : 'Нет' ) ?></li>
                    <li>Копия в Max:   └─> <?php                                               printValue ( $params[ 'row' ][ 'max_message_id' ] ? 'Есть' : 'Нет' ) ?></li>
                    <?php
                }
            ?>
        </ul>
    </section>
