<?php
/**
 * -------------------------------------------------------------------------
 *
 * Сниппет: Сгенерировать карточку задания.
 *
 * -------------------------------------------------------------------------
 *
 * Входные параметры:
 *
 *     $app    = Указатель на объект Вашего приложения.
 *     $params = Данные от шаблона, вызвавшего этот сниппет.
 *               Представляют собой ассоциативный массив из таких элементов:
 *                   'row'        = Запись о выводимом задании.
 *                                  Структуру записи смотрите в методе onInstall() файла "repost.vacancies/Models/Tasks/Tasks.php".
 *                   'admintools' = TRUE, если вывести ещё и кнопки администратора.
 *
 * -------------------------------------------------------------------------
 */

?>  <section class="card task">
        <?php
            if ( $params[ 'admintools' ] ) {
                mimimiModule ([ 'snippets/admintools.tpl', $params[ 'row' ] ]);
            }
        ?>
        <h2><?php printValue ( $params[ 'row' ][ 'name' ] ) ?></h2>
        <ul class="report">
            <li>Наименование:         <?php                                               printValue ( $params[ 'row' ][ 'name'         ] ) ?></li>
            <li>Дата создания:        └─> <?php                                           printValue ( $params[ 'row' ][ 'created'      ] ) ?></li>
            <li>Состояние:                └─> <?php                                       printValue ( $params[ 'row' ][ 'active'       ] ? 'Активна' : 'Неактивна' ) ?></li>
            <li>Через модуль:         Controllers ─> Parser ─> <div class="modname"><?php printValue ( $params[ 'row' ][ 'module'       ] ) ?></div></li>
            <li>Тип данных:                                    └─> <?php                  printValue ( $params[ 'row' ][ 'type'         ] ) ?></li>
            <li>Срок хранения:                                     └─> <?php              printValue ( $params[ 'row' ][ 'lifetime'     ] ) ?> дней</li>
            <li><hr>Начальные параметры:  <div class="code"><?php                         printValue ( $params[ 'row' ][ 'params'       ] ) ?></div></li>
            <li><hr>ИД в фильтре сайта:   <div class="filterid"><?php                     printValue ( $params[ 'row' ][ 'filter_value' ] ) ?></div></li>
            <li>Имя этого фильтра:    └─> <div class="filtername"><?php                   printValue ( $params[ 'row' ][ 'filter_name'  ] ) ?></div></li>
            <li><hr>Отправлять в ТГ-чат:  <div class="chatid"><?php                       printValue ( $params[ 'row' ][ 'tg_chat_id'   ] ) ?></div></li>
            <li>Имя его кнопки:       └─> <div class="chatname"><?php                     printValue ( $params[ 'row' ][ 'chat_caption' ] ) ?></div></li>
            <li><hr>Отправлять в MAX-чат: <div class="chatid"><?php                       printValue ( $params[ 'row' ][ 'max_chat_id'  ] ) ?></div></li>
            <li>Имя его кнопки:       └─> <div class="chatname"><?php                     printValue ( $params[ 'row' ][ 'chat_caption' ] ) ?></div></li>
            <li><a rel="nofollow noopener noreferrer" target="_blank" href="<?php         printValue ( $params[ 'row' ][ 'source_url'   ] ) ?>" class="btn secondary" tabindex="-1">Источник данных</a></li>
        </ul>
    </section>
