<?php
/**
 * -------------------------------------------------------------------------
 *
 * Сниппет: Сгенерировать пагинацию.
 *
 * -------------------------------------------------------------------------
 *
 * Входные параметры:
 *
 *     $app    = Указатель на объект Вашего приложения.
 *     $params = Данные от шаблона, вызвавшего этот сниппет.
 *               Представляют собой ассоциативный массив из таких элементов:
 *                   'rows'    = Список записей на странице.
 *                               Пустая (FALSE) запись в конце списка означает наличие продолжения.
 *                   'pagenum' = Номер текущей страницы.
 *                   'filter'  = Значение фильтра, если отобраны записи конкретного типа.
 *
 * -------------------------------------------------------------------------
 */

?>  <nav>
        <?php
            if ( $params[ 'rows' ] ) {
                $row = reset ( $params[ 'rows' ] );
                if ( $params[ 'pagenum' ] > 1 ) {
                    ?>
                    <a class="btn" href="<?php printListUrl ( $row ) ?>?page=<?php
                                                                                 printValue ( $params[ 'pagenum' ] - 1 );
                                                                                 if ( $params[ 'filter' ] ) {
                                                                                     ?>&filter=<?php printValue ( $params[ 'filter' ] );
                                                                                 }
                                                                             ?>">
                        &laquo;
                    </a>
                    <?php
                }
            }
        ?>
        <a class="btn" href="<?php printSiteUrl ( ) ?>">
            Главная
        </a>
        <?php
            if ( $params[ 'rows' ] ) {
                $next = ! end ( $params[ 'rows' ] );
                if ( $next ) {
                    ?>
                    <a class="btn" href="<?php printListUrl ( $row ) ?>?page=<?php
                                                                                 printValue ( $params[ 'pagenum' ] + 1 );
                                                                                 if ( $params[ 'filter' ] ) {
                                                                                     ?>&filter=<?php printValue ( $params[ 'filter' ] );
                                                                                 }
                                                                             ?>">
                        &raquo;
                    </a>
                    <?php
                }
            }
        ?>
    </nav>
