<!DOCTYPE html>
<html lang="ru-RU">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="index, follow">
        <title>Частые Вопросы-Ответы</title>
        <meta name="description" content="Ответы на некоторые вопросы, которые чаще всего задают насчёт информации на этом сайте.">
        <link rel="canonical" href="<?php printSiteUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet" href="<?php printThemeUrl ( ) ?>css/styles.css">
    </head>
    <body>
        <main>
            <h1>Частые Вопросы-Ответы</h1>
            <details class="faq-item" open>
                <summary>
                    <h2>Как установить?</h2>
                </summary>
                <p>1. Скачайте установочный пакет фреймворка с его  <a href="https://mimimi.software/" rel="nofollow noopener noreferrer" target="_blank">официального сайта</a>. Ищите версию не ниже 7.3. Пакет выглядит как обычный файл ZIP-архива.</p>
                <p>2. Распакуйте архив к себе на компьютер, если будете запускать его на локальном веб-сервере. Или сразу в корневую папку своего сайта, если хотите установить приложение туда.</p>
                <p>3. Откройте в браузере страницу сайта, куда вы только что распаковали архив. Например, для локального веб-сервера это будет страница http://localhost/ - в результате автоматически запустится установщик фреймворка.</p>
                <p>4. Пройдите по шагам установки, выбрав, что желаете установить приложение по имени repost.vacancies. А на странице выбора устанавливаемых модулей отметьте только два: Sqlite, Telegram.</p>
                <p>5. Приложение после первой установки запустится в демонстрационном режиме. В нём задан администратор с паролём по умолчанию demo и суперадминистратор с паролём по умолчанию test.</p>
                <p>Сначала <a href="login" rel="nofollow">авторизуйтесь</a> как суперадминистратор и сразу смените его пароль на какой-нибудь ваш. Затем на странице <a href="settings" rel="nofollow">настроек</a> приложения отключите демо режим, пропишите API-ключ вашего бота в мессенджерах и нажмите там кнопку "Сохранить". После этого опять <a href="login" rel="nofollow">авторизуйтесь</a>, но уже как обычный администратор, и смените его дефолтный пароль тоже на какой-нибудь ваш.</p>
                <p>Теперь останется создать желаемые вами <a href="tasks" rel="nofollow">задания</a> для парсера вакансий. Парсер можно запускать прямым переходом на <a href="parse" rel="nofollow">его страницу</a>. Или прописать адрес этой страницы в CRON-е вашего веб-сервера, чтобы вызов парсера происходил по некоторому расписанию.</p>
            </details>
            <hr>

            <details class="faq-item" open>
                <summary>
                    <h2>Как получить API-ключ бота?</h2>
                </summary>
                <p>Покажу на примере Телеграма. Сначала зайдите в <a href="https://t.me/BotFather" rel="nofollow noopener noreferrer" target="_blank">мастер</a> создания ботов и добавьте нового бота, указав как минимум его @имя и название. Описание и аватар - заполняйте это по желанию.</p>
                <p>На странице мастера появится API-ключ бота. Скопируйте и вставьте его в соответствующее поле на страницу <a href="settings" rel="nofollow">настройки</a> приложения.</p>
                <p>Теперь откройте интересующий канал и добавьте бота в роли администратора с правом публиковать сообщения.</p>
            </details>
            <hr>

            <details class="faq-item" open>
                <summary>
                    <h2>Можно ли добавить вакансию от себя?</h2>
                </summary>
                <p>Нет. Данная версия приложения создана для парсинга вакансий из внешнего источника.</p>
                <p>Если же Вас интересует функция "Добавить вакансию", следует провести следующие изменения в файлах:</p>
                <ul>
                    <li>1. Немного дополнить метод routeFor() главного модуля приложения - это файл Application.php, чтобы маршрутизатор распознавал URL страницы редактирования вакансии и маршрутизировал его на субконтроллер "Dashboard -&gt; Vacancies".</li>
                    <li>2. Дополнить метод run() субконтроллера repost.vacancies/Controllers/Dashboard/Vacancies/Vacancies.php, чтобы тоже распознавал URL страницы редактирования вакансии.</li>
                    <li>2. Изменить метод onUpdate() того же субконтроллера, чтобы обслуживал поля, разрешённые для редактирования. Ведь в текущей версии приложения этот метод обслуживает только поле active.</li>
                    <li>4. Дополнить метод getStructure() модели repost.vacancies/Models/Vacancies/Vacancies.php, чтобы там были перечислены все поля, разрешённые для редактирования.</li>
                </ul>
            </details>
            <hr>

            <details class="faq-item" open>
                <summary>
                    <h2>Можно ли отредактировать вакансию?</h2>
                </summary>
                <p>Нет. Данная версия приложения создана только для показа вакансий, полученных из внешнего источника, без возможности чтобы-либо там изменить.</p>
                <p>Но если Вас интересует функция "Редактировать вакансию", следует провести такие же изменения, как описаны в ответе выше.</p>
            </details>
            <hr>

            <details class="faq-item" open>
                <summary>
                    <h2>Как делать бекап?</h2>
                </summary>
                <p>Вообще говоря, при разработке приложения я даже не подумал о такой функции, чтобы сделать двусторонний процесс Бекап/Восстановление удобным: щелкнул - и база данных скачалась на компьютер, щёлкнул - и база выгрузилась обратно на сайт.</p>
                <p>Поэтому бекап придётся делать иначе, например через FTP-доступ к сайту. Открываете там директорию repost.vacancies/Models и копируете к себе на компьютер файл базы данных. Он назван наподобие database_СЛУЧАЙНЫЙ_ХЕШ.sqlite.</p>
                <p>Восстановление происходит похожим образом: открываете через FTP указанную директорию, копируете туда файл базы данных, который скачали в прошлый бекап.</p>
                <p>Кстати, если удалить файл базы на сайте, приложение запустится словно бы Вы установили его в первый раз. Будет создан новый файл базы, только уже с другим случайным хешем в имени.</p>
            </details>
            <hr>

            <p>Ещё один вопрос был вынесен на отдельную страницу. Он касается <a href="faq/for-developers">истории разработки</a> данного приложения. Прочтите её, если захотите самостоятельно доработать его под себя.</p>
            <nav>
                <a class="btn" href="<?php printSiteUrl ( ) ?>">
                    Главная
                </a>
            </nav>
            <?php
                mimimiModule ( 'snippets/footer.tpl' );
