<?php
/**
 * -------------------------------------------------------------------------
 *
 * Модуль для работы с сеансом пользователя.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Repost Vacancies
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Подключаем из папки ядра фреймворка файл "mimimi.core/Module.php".
     * Там объявлен класс "MimimiModule", являющийся простейшей модульной
     * заготовкой. Этот класс подходит как основа для реализуемого ниже
     * модуля.
     *
     * ---------------------------------------------------------------------
     */

    mimimiInclude ( 'Module.php' );

    /**
     * ---------------------------------------------------------------------
     *
     * Создаём на основе класса той заготовки новый класс, в котором напишем
     * программный код текущего модуля. Обратите внимание как задано имя
     * нового класса - оно сложено из системного префикса "MyMimimi", и имени
     * текущего PHP-файла без расширения.
     *
     * ---------------------------------------------------------------------
     */

    class MyMimimiSession extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Запустить модуль.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  (необязательный) Я вообще не использовал здесь этот параметр.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            session_start ( );
        }

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Получить значение сеансовой переменной.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $name     Имя желаемой переменной.
         * @param   string  $default  (необязательный) Значение по умолчанию, если такая переменная ещё не существует в сеансе.
         * @return  mixed
         *
         * -----------------------------------------------------------------
         */

        public function get ( $name, $default = '' ) {
            return isset ( $_SESSION[ $name ] ) ? $_SESSION[ $name ]
                                                : $default;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Сохранить значение в переменной сеанса.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $name   Имя желаемой переменной.
         * @param   mixed   $value  Её новое значение.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        public function set ( $name, $value ) {
            $_SESSION[ $name ] = $value;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Удалить переменную из сеанса.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $name  Имя желаемой переменной.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        public function remove ( $name ) {
            unset ( $_SESSION[ $name ] );
        }
    }
