<?php
/**
 * -------------------------------------------------------------------------
 *
 * Модуль контроллера SEO.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Repost Vacancies
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Подключаем из папки ядра фреймворка файл "mimimi.core/Module.php".
     * Там объявлен класс "MimimiModule", являющийся простейшей модульной
     * заготовкой. Этот класс подходит как основа для реализуемого ниже
     * модуля.
     *
     * ---------------------------------------------------------------------
     */

    mimimiInclude ( 'Module.php' );

    /**
     * ---------------------------------------------------------------------
     *
     * Создаём на основе класса той заготовки новый класс, в котором напишем
     * программный код текущего модуля. Обратите внимание как задано имя
     * нового класса - оно сложено из имени класса вышестоящего модуля, то
     * есть "MyMimimiControllers", и имени текущего PHP-файла без расширения.
     *
     * ---------------------------------------------------------------------
     */

    class MyMimimiControllersSeo extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Маршрутизировать запрос к сопоставленному макету шаблона.
         *
         * -----------------------------------------------------------------
         *
         * Этот метод обслуживает следующие URL-ы:
         *
         *     https://ваш.сайт/robots.txt
         *     https://ваш.сайт/sitemap.xml
         *     https://ваш.сайт/ЛЮБОЙ-НЕПРАВИЛЬНЫЙ-URL
         *
         * Генерация ответа пройдёт на основе одного из таких макетов:
         *
         *     repost.vacancies/Themes/default/robots.tpl
         *     repost.vacancies/Themes/default/sitemap.tpl
         *     repost.vacancies/Themes/default/page404.tpl
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $url  (необязательный) Относительный URL запрошенной страницы.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        function run ( $url = '' ) {
            switch ( $url ) {
                case 'robots.txt':
                     $this->app->views->html->text ( 'robots.tpl' );
                     break;
                case 'sitemap.xml':
                     $this->app->models->vacancies->removeOld ( );
                     $rows = $this->app->models->vacancies->getSitemap ( );
                     $this->app->views->html->xml ([ 'sitemap.tpl', $rows ]);
                     break;
                case '404':
                     $this->app->views->html->error ( 'page404.tpl' );
                     break;
            }
        }
    }
