<?php
/**
 * -------------------------------------------------------------------------
 *
 * Модуль контроллера "Частые вопросы-ответы".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Repost Vacancies
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Подключаем из папки ядра фреймворка файл "mimimi.core/Module.php".
     * Там объявлен класс "MimimiModule", являющийся простейшей модульной
     * заготовкой. Этот класс подходит как основа для реализуемого ниже
     * модуля.
     *
     * ---------------------------------------------------------------------
     */

    mimimiInclude ( 'Module.php' );

    /**
     * ---------------------------------------------------------------------
     *
     * Создаём на основе класса той заготовки новый класс, в котором напишем
     * программный код текущего модуля. Обратите внимание как задано имя
     * нового класса - оно сложено из имени класса вышестоящего модуля, то
     * есть "MyMimimiControllers", и имени текущего PHP-файла без расширения.
     *
     * ---------------------------------------------------------------------
     */

    class MyMimimiControllersFaq extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Метод: Маршрутизировать запрос к сопоставленному макету шаблона.
         *
         * -----------------------------------------------------------------
         *
         * Этот метод обслуживает следующие URL-ы:
         *
         *     https://ваш.сайт/faq
         *     https://ваш.сайт/faq/for-developers
         *
         * Генерация HTML-кода страницы пройдёт на основе одного из таких
         * макетов:
         *
         *     repost.vacancies/Themes/default/faq.tpl
         *     repost.vacancies/Themes/default/faq/for-developers.tpl
         *     repost.vacancies/Themes/default/page404.tpl
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $url  (необязательный) Относительный URL запрошенной страницы.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        public function run ( $url = '' ) {
            switch ( $url ) {
                case 'faq':
                     $this->app->views->html->run ( 'faq.tpl' );
                     break;
                case 'faq/for-developers':
                     $this->app->views->html->run ( 'faq/for-developers.tpl' );
                     break;
                default:
                     $this->owner->seo->run ( '404' );
            }
        }
    }
