<?php
/**
 * -------------------------------------------------------------------------
 * The CACHE module to work with data stored in memory.
 *
 * -------------------------------------------------------------------------
 *
 * Implemented properties below are:
 *     PROTECTED  $memory
 *
 * Implemented methods below are:
 *     get
 *     set
 *     remove
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Modules
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * -------------------------------------------------------------------------
 */

mimimiInclude('Module.php');
class MimimiCache extends MimimiModule {

    /**
     * ---------------------------------------------------------------------
     * Define storage area.
     *
     * @var array
     * @access protected
     * ---------------------------------------------------------------------
     */

    protected $memory = [];

    /**
     * ---------------------------------------------------------------------
     * Public method to get a cached parameter.
     *
     * @public
     * @param   string  $param  Name of parameter.
     * @param   mixed   $def    Default value if parameter not found.
     * @return  mixed           Retrieved value.
     * ---------------------------------------------------------------------
     */

    public function get ( $param, $def = null ) {
        return isset($this->memory[$param])
               ? $this->memory[$param]
               : $def;
    }

    /**
     * ---------------------------------------------------------------------
     * Public method to cache a parameter.
     *
     * @public
     * @param   string  $param  Name of parameter.
     * @param   mixed   $value  Value to save.
     * ---------------------------------------------------------------------
     */

    public function set ( $param, & $value ) {
        $this->memory[$param] = $value;
    }

    /**
     * ---------------------------------------------------------------------
     * Public method to delete a cached parameter.
     *
     * @public
     * @param   string  $param  Name of parameter.
     * ---------------------------------------------------------------------
     */

    public function remove ( $param ) {
        if (isset($this->memory[$param])) {
            unset($this->memory[$param]);
        }
    }
};