<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a STEP-4 page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Do some backend logic:
     *     load HELPER file
     *     start session
     *
     * ---------------------------------------------------------------------
     */

    mimimiModule ( 'helper.tpl' );

    startSession ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Do some security logic:
     *     if page STEP-3 is not passed
     *         redirect to homepage
     *     remember that page STEP-4 is not passed
     *     send status "200 OK"
     *
     * ---------------------------------------------------------------------
     */

    if ( hasNoCheckpoint ( 'step3' ) ) {
        gotoHome ( );
    }
    clearCheckpoint ( 'step4' );

    sendStatus200 ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Simulate a post retrieved from the database.
     *
     * ---------------------------------------------------------------------
     */

    global  $post;
            $post = [
                'title' => 'Install the MiMiMi - Database',
                'meta'  => 'This is an installer page to configure an access to your database.',
                'h1'    => 'Configure database'
            ];

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?>  <?php mimimiModule ( 'blocks/header.tpl' ) ?>
    <main>
        <h1>
            <strong>Step 4 of 4</strong>
            <?php printPageH1 ( ) ?>
        </h1>
        <p>You need to specify the parameters for access to your database.</p>
        <?php mimimiModule ( 'blocks/form-4.tpl' ) ?>
    </main>
    <?php mimimiModule ( 'blocks/footer.tpl' ) ?>
