<?php
/**
 * -------------------------------------------------------------------------
 *
 * The class for the installer application.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Installer
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Application.php' );

    class MyMimimiApplication extends MimimiApplication {

        /**
         * -----------------------------------------------------------------
         *
         * Renders the current page using its template file.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   mixed  $params  (optional) Some parameters from the calling process.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        public function run ( $param = '' ) {
            mimimiLoad ( 'RoutinesWeb.php' );

            $uri = mimimiUri  ( FALSE );
            $uri = strtolower ( $uri  );
            switch ( $uri ) {
                case '':
                     mimimiModule ( 'home.tpl' );
                     break;
                case 'step-1':
                case 'step-2':
                case 'step-3':
                case 'step-4':
                case 'step-5':
                case 'final':
                     mimimiModule ( $uri . '.tpl' );
                     break;
                default:
                     mimimiModule ( 'error404.tpl' );
            }
        }
    };
