<!DOCTYPE html>
<html lang="en">
    <head>
        <title>How to use a bbCode?</title>
        <meta name="description" content="It is a short instruction that demonstrates how to create a bbCode and use it.">

        <!-- You can limit the list of allowed editing tools for this page to a specific name or any one (use an empty string) -->
        <meta name="editing-permission" content="editor">

        <!-- Note that this style URL must be specified relative to the "static.pages.only/Themes/css/pages" directory -->
        <link rel="stylesheet" href="default.css">
    </head>
    <body>
        <p>[insert=topmenu.tpl]</p>

        <article>
            <h1>How to use a bbCode?</h1>
            <p>It is a short instruction that demonstrates how to create a bbCode and use it.</p>

            <h2>Creating</h2>
            <p>First you need to add or upload the bbCode file you want. Let's make an example and name it "My Random Number".</p>
            <p>I will describe this process step by step. First of all, you need to <a href="login" rel="nofollow">Log In</a> to the site as an administrator. It looks like this:</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/how-to/use-bbCode-1.png" loading="lazy" alt=""/>
            </figure>
            <p>Then you should go to the <a href="bbcodes" rel="nofollow">bbCodes</a> page. It looks like this:</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/how-to/use-bbCode-2.png" loading="lazy" alt=""/>
            </figure>
            <p>There are two possible ways.</p>

            <h2>Way 1</h2>
            <p>If you want to enter bbCode markup from blank sheet, you should use the <a href="bbcodes/add" rel="nofollow">Add New</a> button. It looks like this:</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/how-to/use-bbCode-3.png" loading="lazy" alt=""/>
            </figure>
            <p>Suppose you want to use the following markup for that bbCode. It simply displays a message "My random number is ..." with a generated random number:</p>
            <pre><code class="language-html">&lt;p&gt;
    My random number is
    &lt;?php echo rand() ?&gt;
&lt;/p&gt;</code></pre>
            <p>So, when adding a new bbCode, you need to enter the following data in the input form as shown in the screenshot below.</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/how-to/use-bbCode-4.png" loading="lazy" alt=""/>
            </figure>

            <h2>Way 2</h2>
            <p>If you already have a marked up bbCode file, you should use the <a href="bbcodes/upload" rel="nofollow">Upload New</a> button. It looks like this:</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/how-to/use-bbCode-5.png" loading="lazy" alt=""/>
            </figure>
            <p>Please note that in each of these ways, you will have to specify a relative URL of the bbCode file that will be saved. Let's specify it as <code>my/random-number.tpl</code> as shown in the screenshots above.</p>

            <h2>Great</h2>
            <p>You have just uploaded or added a new bbCode. Its URL should immediately appear in the bbCodes list, as shown in the next screenshot.</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/how-to/use-bbCode-6.png" loading="lazy" alt=""/>
            </figure>
            <p>Now you are ready to use this bbCode on any static pages of your site.</p>

            <h2>Using</h2>
            <p>Now you should go to the page <a href="add" rel="nofollow">Add New Page</a> and try to use the "Insert dynamic block" tool.</p>
            <p>This drop down button will contain all your bbCodes including the <code>my/random-number.tpl</code> you just created. You need to click on this element to insert its <code>&#x5B;insert=my/random-number.tpl&#x5D;</code> tag into the page.</p>
            <p>It looks like this:</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/how-to/use-bbCode-7.png" loading="lazy" alt=""/>
            </figure>
            <p>Now, when a visitor sees this page, it will look like this.</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/how-to/use-bbCode-8.png" loading="lazy" alt=""/>
            </figure>

            <h2>Static input parameters</h2>
            <p>You may pass some unnamed parameters to your bbCode. These parameters must be declared after the bbCode file name separated by spaces. For example, let's define two parameters: 123, 456 - to generate a random number in the range 123 ... 456.</p>
            <pre><code class="language-html">&lt;p&gt; &#x5B;insert=my/random-number.tpl 123 456&#x5D; &lt;/p&gt;</code></pre>
            <p>However, you should remember that the input parameters are optional. The administrator can declare them at his own discretion. For example:</p>
            <pre><code class="language-html">&lt;p&gt; &#x5B;insert=my/random-number.tpl        &#x5D; &lt;/p&gt;
&lt;p&gt; &#x5B;insert=my/random-number.tpl 123 456&#x5D; &lt;/p&gt;</code></pre>
            <p>So you will have to take this situation into account. Let's change the bbCode file above to use these optional parameters:</p>
            <pre><code class="language-html">&lt;p&gt;
    My random number is
    &lt;?php echo isset($params[1]) ? rand($params[0], $params[1])
                                 : rand() ?&gt;
&lt;/p&gt;</code></pre>
            <p>Good luck!</p>
        <article>
    </body>
</html>
