<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the page "Widgets -> Recycle Bin".
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app  = your application
 *     $item = relative URL of the file that will be dropped
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    global $item;
    $data    = $app->projects->getProject ( );
    $success = '';
    $screen  = 1;

    /**
     * ---------------------------------------------------------------------
     *
     * If the requested file exists.
     *
     * ---------------------------------------------------------------------
     */

    if ( helperHasFile ( $item ) ) {
        $screen = 2;

        /**
         * -----------------------------------------------------------------
         *
         * If the confirmation form was submitted.
         *
         * -----------------------------------------------------------------
         */

        if ( getFormInput ( 'submit' ) ) {

            if ( helperHasProduction ( ) ) {
                helperRemoveFile ( $item );
                $screen = 3;

            /**
             * -------------------------------------------------------------
             *
             * Otherwise, prepare an error message.
             *
             * -------------------------------------------------------------
             */

            } else {
                $success = 'Sorry, you are currently in demo mode. Any create/add/edit/delete operation is only simulated in this mode. To see how it really works, download this package and install it on your site or localhost.';
            }
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

    switch ( $screen ) {

        /**
         * -----------------------------------------------------------------
         *
         * On the first screen, we show a message about missing file.
         *
         * -----------------------------------------------------------------
         */

        case 1:
             ?>
             <div class="modal">
                 <h1>Not Found</h1>
                 <p>Sorry, you are trying to delete a file <code><?php printValue ( $item ) ?></code> that is not present in the current project <code><?php printValue ( $data[ 'dir' ] ) ?></code>.</p>
                 <footer class="buttons">
                     <button class="btn" onclick="app.closeWindow ( this )">CLOSE</button>
                 </footer>
             </div>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the second screen, we ask the user to confirm his intention.
         *
         * -----------------------------------------------------------------
         */

        case 2:
             ?>
             <form class="modal" action="<?php printPageUrl ( ) ?>" method="post">
                 <div class="success"><?php printValue ( $success ) ?></div>

                 <h1>Are you sure?</h1>
                 <p>This will delete the <code><?php printValue ( $item ) ?></code> file located in the current project <code><?php printValue ( $data[ 'dir' ] ) ?></code>.</p>
                 <footer class="buttons">
                     <button class="btn" name="submit" type="submit" value="1">DELETE</button>
                     <button class="btn" onclick="app.closeWindow ( this )"   >CANCEL</button>
                 </footer>
             </form>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the third screen, we just redirect the user to the home page.
         *
         * -----------------------------------------------------------------
         */

        case 3:
        default:
             mimimiModule ( 'snippets/go-home.tpl' );
             break;
    }
