<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the page "Topmenu -> File -> Exit".
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    $screen = helperHasChanges ( )
                               ? 1
                               : 2;

    switch ( $screen ) {
        case 1:
             if ( getFormInput ( 'submit' ) ) {
                 helperLogoutUser ( );
                 $screen = 2;
             }
             break;
        case 2:
        default:
             helperLogoutUser ( );
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

    switch ( $screen ) {

        /**
         * -----------------------------------------------------------------
         *
         * On the first screen, we ask the user to confirm his intention.
         *
         * -----------------------------------------------------------------
         */

        case 1:
             ?>
             <form class="modal notification" action="<?php printPageUrl ( ) ?>" method="post">
                 <h1>Are you sure?</h1>
                 <p>This will result in the loss of changes to project files made during the current session.</p>
                 <footer class="buttons">
                     <button class="btn" name="submit" type="submit" value="1">EXIT</button>
                     <button class="btn" onclick="app.closeWindow ( this )"   >NO</button>
                 </footer>
             </form>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the second screen, we just clear the name of the currently
         * open project in the browser session (local storage) and redirect
         * the user to the home page.
         *
         * Please note that this script runs before the page's main script
         * is loaded. That's why we don't use the "app.session" property and
         * its method "removeItem" here.
         *
         * -----------------------------------------------------------------
         */

        case 2:
        default:
             ?>
             <script>
                 localStorage.removeItem ( 'project'         );
                 localStorage.removeItem ( 'lastTab-project' );
                 localStorage.removeItem ( 'editor-project'  );
                 window.location.replace ( '<?php printSiteUrl ( ) ?>' )
             </script>
             <?php
    }
