<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the menu item "View -> Preview".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiMenuViewPreview extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the menu item "View -> Preview".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            $activated = $this->app->menu->file->isActive ( );
            return [ 'preview' => [ 'name'     => 'Preview',
                                    'inactive' => ! $activated,
                                    'title'    => 'Launches the project or its file.',

                                    'subitems' => [ [ 'name'     => 'Project',
                                                      'shortcut' => 'r',
                                                      'inactive' => ! $activated,
                                                      'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M200-120q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h560q33 0 56.5 23.5T840-760v560q0 33-23.5 56.5T760-120H200Zm0-80h560v-480H200v480Zm280-80q-82 0-146.5-44.5T240-440q29-71 93.5-115.5T480-600q82 0 146.5 44.5T720-440q-29 71-93.5 115.5T480-280Zm0-60q56 0 102-26.5t72-73.5q-26-47-72-73.5T480-540q-56 0-102 26.5T306-440q26 47 72 73.5T480-340Zm0-100Zm0 60q25 0 42.5-17.5T540-440q0-25-17.5-42.5T480-500q-25 0-42.5 17.5T420-440q0 25 17.5 42.5T480-380Z"/></svg>',
                                                      'url'      => $base,
                                                      'title'    => 'Launches the main project file.' ],

                                                    [ 'name'     => 'File',
                                                      'shortcut' => 'f5',
                                                      'inactive' => ! $activated,
                                                      'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M200-120q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h560q33 0 56.5 23.5T840-760v560q0 33-23.5 56.5T760-120H200Zm0-80h560v-480H200v480Zm280-80q-82 0-146.5-44.5T240-440q29-71 93.5-115.5T480-600q82 0 146.5 44.5T720-440q-29 71-93.5 115.5T480-280Zm0-60q56 0 102-26.5t72-73.5q-26-47-72-73.5T480-540q-56 0-102 26.5T306-440q26 47 72 73.5T480-340Zm0-100Zm0 60q25 0 42.5-17.5T540-440q0-25-17.5-42.5T480-500q-25 0-42.5 17.5T420-440q0 25 17.5 42.5T480-380Z"/></svg>',
                                                      'url'      => $base,
                                                      'title'    => 'Launches the project file currently selected by the editor tab.' ] ] ] ];

        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/menu/view/preview/
         *                           https://your.site/menu/view/preview/SOME-FILE-URL
         *                                                               └─────┬─────┘
         *                                                                     └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the page was rendered successfully.
         *                           FALSE if there is no template file for this page.
         *                           FALSE if the menu item URL contains unexpected parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            switch ( $params ) {
                case '': return $this->app->menu->file->isActive ( )
                                                          ? $this->app->renderPage ( 'view/project.tpl' )
                                                          : $this->app->renderNotAllowed ( );
            }
            global $item;
                   $item = $params;
            return $this->app->menu->file->isActive ( )
                                             ? $this->app->renderPage ( 'view/file.tpl' )
                                             : $this->app->renderNotAllowed ( );
        }
    };
