<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the menu item "File -> Log In".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiMenuFileLogin extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the menu item "File -> Log In".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            return [ 'login' => [ 'name'     => 'Log In',
                                  'shortcut' => 'l',
                                  'inactive' => $this->app->checkForAdmin ( ),
                                  'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M480-120v-80h280v-560H480v-80h280q33 0 56.5 23.5T840-760v560q0 33-23.5 56.5T760-120H480Zm-80-160-55-58 102-102H120v-80h327L345-622l55-58 200 200-200 200Z"/></svg>',
                                  'url'      => $base,
                                  'title'    => 'Opens a new IDE session.' ] ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/menu/file/login/UNEXPECTED-PARAMETERS
         *                                                             └────────┬──────────┘
         *                                                                      └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the page was rendered successfully.
         *                           FALSE if there is no template file for this page.
         *                           FALSE if the menu item URL contains unexpected parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return $params == ''
                            ? $this->app->renderPage ( 'file/login.tpl' )
                            : FALSE;
        }
    };
