<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module to request checkpoints that serve the API.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Collection.php', FALSE );

    class MyMimimiApi extends MyMimimiCollection {

        /**
         * -----------------------------------------------------------------
         *
         * Launches a checkpoint associated with the called URL.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $url  The URL that was called using Javascript.
         * @return  bool          TRUE  if the checkpoint was launched successfully.
         *                        FALSE if there is no associated module or operation.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $url = '' ) {
            $module = $url ? $this->findModule ( $url, 'run' )
                           : FALSE;
            return $module ? $module->run ( $url )
                           : FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Reset the namespace simulator. You should reset it because this
         * module may have child or more nested modules with functionality
         * related to their hierarchy.
         *
         * -----------------------------------------------------------------
         *
         * @var    string
         * @access protected
         *
         * -----------------------------------------------------------------
         */

        protected $myNodeFile = __FILE__;
    };
