<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a page to append a new vendor product.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app    = your application
 *     $params = database entry retrieved by the "Vendors" module
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute server logic according to this page type.
     *
     * ---------------------------------------------------------------------
     */

    ob_start ( );
        mimimiModule ( [ 'snippets/form-product.tpl', [ 'id'          => 0               ,
                                                        'vendor_id'   => $params[ 'id' ] ,
                                                        'image'       => ''              ,
                                                        'name'        => ''              ,
                                                        'description' => ''              ,
                                                        'price'       => ''              ,
                                                        'amount'      => 0               ,
                                                        'color'       => ''              ] ] );
        $form = ob_get_contents ( );
    ob_end_clean ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML    (   );
    sendStatus200     (   );
    sendHeaderExpires ( 0 );
    stopIfHead        (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en-US">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/reset.min.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/fonts.css">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">

        <meta name="robots" content="noindex, nofollow">
        <title>
            Adding a New Product to <?php printValue ( $params[ 'brand' ] ) ?>
        </title>
    </head>

    <body>
        <div class="wrapper">
            <div class="screen">
                <div class="app-bar">
                    <div class="bottom-area">
                        <div class="price">
                            <img class="logo" src="<?php printValue ( $params[ 'logo' ] ) ?>" loading="lazy" alt="">
                        </div>
                        <a class="button" href="<?php printSiteUrl ( ) ?>">
                            <p>GO TO HOME</p>
                        </a>
                    </div>
                </div>

                <h1 class="title">
                    A New Product
                    <small>Please edit its form below</small>
                </h1>

                <form class="shop-items" method="post">
                    <?php echo $form ?>
                </form>
            </div>
        </div>
    </body>
</html>