<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the list of sitemap URLs.
 *
 * The following code renders an XML link to the root page of that list,
 * and then XML links to non-disabled pages associated with some viewer
 * name passed by $params argument.
 *
 * -------------------------------------------------------------------------
 *
 * These system variables are available:
 *
 *     $params   = name of the desired viewer                ( see file tiny.news.feed/Themes/default/*-sitemap.tpl )
 *     $app      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $app )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Read links to non-disabled pages.
     *
     * ---------------------------------------------------------------------
     */

                                                        // -----------------
    $list = $app->getSitemap(                           // get a list of URLs           ( see file tiny.news.feed/Application.php -> getSitemap )
                $params                                 // . . using this viewer module ( see file tiny.news.feed/Viewers/[$params]/[$params].php )
            );                                          //
                                                        // -----------------
    if ( $list ) {                                      // if there is a non-empty list

        /**
         * -----------------------------------------------------------------
         *
         * Render a link to the root page.
         *
         * -----------------------------------------------------------------
         */

        ?>
        <url>
            <loc>
                <?php                                   // -----------------
                    tinyPrintUrl([                      //     print the page URL ( see file tiny.news.feed/Helper/Helper.php -> tinyPrintUrl )
                        'url' => $params                //     . . for this pseudo record
                    ]);                                 //
                ?>
            </loc>
        </url>
        <?php

        /**
         * -----------------------------------------------------------------
         *
         * Render another links.
         *
         * -----------------------------------------------------------------
         */

                                                        // -----------------
        foreach ( $list as $row ) {                     //     walk through the provided list
            ?>
            <url>
                <loc>
                    <?php                               // -----------------
                        tinyPrintUrl(                   //         print the page URL ( see file tiny.news.feed/Helper/Helper.php -> tinyPrintUrl )
                            $row                        //         . . for this page record
                        );                              //
                    ?>
                </loc>
            </url>
            <?php                                       //
        }                                               //
    }                                                   //
                                                        // -----------------
