<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the home page when it has not yet been created.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         ( );
    sendStatus200          ( );
    sendHeaderLastModified ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Is the current visitor an administrator? We get this boolean flag
     * exactly before generating the page content because the helperAmIAdmin()
     * routine algorithm implies sending server headers that can no longer
     * be sent if this routine is used inside content generation.
     *
     * ---------------------------------------------------------------------
     */

    $amIAdmin = helperAmIAdmin ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            Welcome
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="index, follow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/welcome.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error">
                Your home page has not yet been created!
            </aside>

            <main class="content">
                <div class="left">
                    <h1 class="title">
                        Welcome
                    </h1>
                    <p>You are watching the <b>Static Pages Only</b> demo. It is a web application that allows you to create a site entirely from static pages.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>toc" title="View the list of existing pages">
                        Table of Contents
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <p>At this time, your site's home page has not been created yet, so you are seeing this message.</p>

                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * Display the correct button depending on whether
                             * the current visitor is an administrator.
                             *
                             * ---------------------------------------------
                             */

                            if ( $amIAdmin ) {
                                ?>
                                <p>You can create this page right now. The application has a built-in HTML editor that makes such job easy.</p>
                                <a class="btn" href="<?php printSiteUrl ( ) ?>add" rel="nofollow" title="Create a new home page">
                                    Add Page
                                </a>

                                <?php
                            } else {
                                ?>
                                <p>You are not currently logged in. Therefore, to add a home page, you must first log in.</p>
                                <a class="btn" href="<?php printSiteUrl ( ) ?>login" rel="nofollow" title="Authorize as an administrator">
                                    Log In
                                </a>

                                <?php
                            }
                        ?>
                    </div>
                </div>
            </main>

            <footer class="footnote">
                <?php
                    /**
                     * -----------------------------------------------------
                     *
                     * Display administrator buttons.
                     *
                     * -----------------------------------------------------
                     */

                    if ( $amIAdmin ) {
                        ?>
                        <details class="tools">
                            <summary title="Show / Hide a list of application entities">
                                Database
                            </summary>
                            <div>
                                <a class="tool" href="<?php printSiteUrl ( ) ?>pages" rel="nofollow" title="Manage pages">
                                    Pages
                                </a>

                                <a class="tool" href="<?php printSiteUrl ( ) ?>styles" rel="nofollow" title="Manage page styles">
                                    Styles
                                </a>

                                <a class="tool" href="<?php printSiteUrl ( ) ?>bbcodes" rel="nofollow" title="Manage bbCode blocks">
                                    bbCodes
                                </a>

                                <a class="tool" href="<?php printSiteUrl ( ) ?>fragments" rel="nofollow" title="Manage Page Constructor blocks">
                                    Fragments
                                </a>
                            </div>
                        </details>

                        <a class="tool" href="<?php printSiteUrl ( ) ?>settings" rel="nofollow" title="Edit site settings">
                            Settings
                        </a>

                        <details class="tools">
                            <summary title="Show / Hide a list of technical links">
                                SEO
                            </summary>
                            <div>
                                <a class="tool" href="<?php printSiteUrl ( ) ?>sitemap.xml" rel="nofollow" target="_blank" title="View the sitemap.xml document intended for crawlers">
                                    Sitemap.xml
                                </a>

                                <a class="tool" href="<?php printSiteUrl ( ) ?>robots.txt" rel="nofollow" target="_blank" title="View the robots.txt document intended for crawlers">
                                    Robots.txt
                                </a>
                            </div>
                        </details>

                        <a class="tool" href="<?php printSiteUrl ( ) ?>logout" rel="nofollow" title="Terminate your administrator session">
                            Log Out
                        </a>
                        <?php
                    }
                ?>

                <a href="<?php printSiteUrl ( ) ?>credits" title="Gratitude to third party developers">
                    Credits
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/welcome.js"></script>
    </body>
</html>
