<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the default Table Of Contents page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         ( );
    sendStatus200          ( );
    sendHeaderLastModified ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Is the current visitor an administrator? We get this boolean flag
     * exactly before generating the page content because the helperAmIAdmin()
     * routine algorithm implies sending server headers that can no longer
     * be sent if this routine is used inside content generation.
     *
     * ---------------------------------------------------------------------
     */

    global $amIAdmin;
           $amIAdmin = helperAmIAdmin ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            Table Of Contents
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="index, follow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/toc.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error"></aside>

            <main class="content list">
                <div class="left">
                    <h1 class="title">
                        Table of Contents
                    </h1>
                    <p>To make it easier for you to find the page you need, we have created a simple sitemap.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                        Home Page
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <h2>Page Hierarchy</h2>
                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * Collect all existing pages including default
                             * pages and display them as a UL list.
                             *
                             * ---------------------------------------------
                             *
                             * We use array merging to override default pages
                             * if there are published instances of them on
                             * the site.
                             *
                             * ---------------------------------------------
                             */

                            $pages    = helperCollectPages ( );
                            $defaults = [ ''        => 'Welcome (default Home page)'      ,
                                          'toc'     => 'Table of Contents (default page)' ,
                                          'credits' => 'Credits (default page)'           ];
                            $list     = array_merge ( $defaults, $pages );
                            mimimiModule ([ 'snippets/list-pages.tpl', $list ]);

                            /**
                             * ---------------------------------------------
                             *
                             * Display administrator buttons.
                             *
                             * ---------------------------------------------
                             */

                            if ( $amIAdmin ) {
                                ?>
                                <h2>Do you know...</h2>
                                <p>This is the default page that only lists all existing pages. But you can create a specific page instead. The app has a built-in HTML editor that makes such work easier.</p>
                                <a class="btn" href="<?php printSiteUrl ( ) ?>add/toc" rel="nofollow" title="Replace this page with your own">
                                    Replace Page
                                </a>
                                <?php
                            }
                        ?>
                    </div>
                </div>
            </main>

            <footer class="footnote"><?php
                if ( $amIAdmin ) {
                    ?>
                    <a class="tool" href="<?php printSiteUrl ( ) ?>styles" rel="nofollow" title="Manage page styles">
                        Styles
                    </a>

                    <a class="tool" href="<?php printSiteUrl ( ) ?>bbcodes" rel="nofollow" title="Manage bbCode blocks">
                        bbCodes
                    </a>

                    <a class="tool" href="<?php printSiteUrl ( ) ?>fragments" rel="nofollow" title="Manage Page Constructor blocks">
                        Fragments
                    </a>
                    <?php
                }
            ?></footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/toc.js"></script>
    </body>
</html>
