/**
 * -------------------------------------------------------------------------
 *
 * The frontend scripts for the Settings page.
 *
 * -------------------------------------------------------------------------
 *
 * If you need some JavaScript logic on this page, it can be written below.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    import ( './login.js' );

    /**
     * ---------------------------------------------------------------------
     *
     * To generate a new password.
     *
     * ---------------------------------------------------------------------
     */

    const generatePassword = ( btn, len = 12 ) => {
        let label = btn.closest ( 'label' ),
            input,
            char,
            pass  = '',
            count = 2;
        while ( len > 0 ) {
            char = String.fromCharCode ( 32 + Math.random ( ) * 94 );
            if ( char != '"'
            &&   char != '$'
            &&   char != "'"
            &&   char != '\\' ) {
                pass += char;
                len--;
            }
        };
        while ( label && count ) {
            if ( label.tagName == 'LABEL' ) {
                input = label.querySelector ( 'input[type="text"]' );
                if ( ! input ) return;
                input.value = pass;
                count--;
            }
            label = label.previousSibling;
        }
    };

    /**
     * ---------------------------------------------------------------------
     *
     * To generate a new storage path.
     *
     * ---------------------------------------------------------------------
     */

    const generatePath = ( btn, len = 20, segments = 1 ) => {
        const label = btn.closest ( 'label' );
        if ( label ) {
            const input = label.querySelector ( 'input[type="text"]' );
            if ( input ) {
                let code,
                    char,
                    path = '';
                while ( segments > 0 ) {
                    for ( let i = 0; i < len; i++ ) {
                        code = 48 + Math.random ( ) * ( 10 + 26 );
                        if ( code > 58 ) code += 39;
                        char = String.fromCharCode ( code );
                        path += char;
                    }
                    path += '/';
                    segments--;
                };
                input.value = path;
            }
        }
    };

    /**
     * ---------------------------------------------------------------------
     *
     * To generate a new bbCode URL.
     *
     * ---------------------------------------------------------------------
     */

    const generateBBcodeUrl = ( btn, len = 4, segments = 4 ) => {
        const label = btn.closest ( 'label' );
        if ( label ) {
            const input = label.querySelector ( 'input[type="text"]' );
            if ( input ) {
                let code,
                    char,
                    url = '';
                while ( segments > 0 ) {
                    for ( let i = 0; i < len; i++ ) {
                        code = 48 + Math.random ( ) * ( 10 + 26 );
                        if ( code > 58 ) code += 39;
                        char = String.fromCharCode ( code );
                        url += char;
                    }
                    segments--;
                    if ( segments ) url += '-';
                };
                input.value = url + '.tpl';
            }
        }
    };

    /**
     * ---------------------------------------------------------------------
     *
     * To generate a new Fragment URL.
     *
     * ---------------------------------------------------------------------
     */

    const generateFragmentUrl = ( btn, len = 4, segments = 4 ) => {
        generateBBcodeUrl ( btn, len, segments );
    };
