<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the CSS Files page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         (   );
    sendStatus200          (   );
    sendHeaderExpires      ( 0 );
    sendHeaderLastModified (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            CSS Files
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="noindex, nofollow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error"></aside>

            <main class="content list">
                <div class="left">
                    <h1 class="title">
                        CSS Files
                    </h1>
                    <p>To make page styling more diverse, this app provides the ability to edit the list of style files.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                        Home Page
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <h2>Page Styles</h2>
                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * Collect all existing page styles.
                             *
                             * ---------------------------------------------
                             */

                            $files = helperCollectStyles ( );

                            /**
                             * ---------------------------------------------
                             *
                             * Define a local routine to display style list.
                             *
                             * ---------------------------------------------
                             */

                            function localDisplayList ( $list, $level = 0 ) {
                                ?>
                                <ul>
                                    <?php
                                        foreach ( $list as $segment => & $url ) {
                                            ?>
                                            <li>
                                                <?php
                                                    /**
                                                     * ---------------------
                                                     *
                                                     * If it is a node.
                                                     *
                                                     * ---------------------
                                                     */

                                                    if ( is_array ( $url ) ) {

                                                        if ( isset ( $url[ '' ] ) ) {
                                                            ?>
                                                            <a href="<?php printSiteUrl (                             );
                                                                           printValue   ( 'styles/edit/' . $url[ '' ] ) ?>" title="Edit this CSS file" rel="nofollow">
                                                                <?php printValue ( $url[ '' ] ) ?>
                                                            </a>

                                                            <small class="tools">
                                                                <a href="<?php printThemeUrl (                           );
                                                                               printValue    ( 'css/pages/' . $url[ '' ] ) ?>" title="View this CSS file content" rel="nofollow" target="_blank">
                                                                    view
                                                                </a> &bullet; <a href="<?php printSiteUrl (                               );
                                                                                             printValue   ( 'styles/upload/' . $url[ '' ] ) ?>" title="Replace this CSS file with a new one" rel="nofollow">
                                                                                  upload
                                                                              </a> &bullet; <a href="<?php printSiteUrl (                                 );
                                                                                                           printValue   ( 'styles/download/' . $url[ '' ] ) ?>" title="Download this CSS file" rel="nofollow">
                                                                                                download
                                                                                            </a> &bullet; <a href="<?php printSiteUrl (                             );
                                                                                                                         printValue   ( 'styles/copy/' . $url[ '' ] ) ?>" title="Clone this CSS file" rel="nofollow">
                                                                                                              copy
                                                                                                          </a> &bullet; <a href="<?php printSiteUrl (                               );
                                                                                                                                       printValue   ( 'styles/delete/' . $url[ '' ] ) ?>" title="Delete this CSS file" rel="nofollow">
                                                                                                                            delete
                                                                                                                        </a>
                                                            </small>
                                                            <?php

                                                            unset ( $url[ '' ] );

                                                        /**
                                                         * ---------------------
                                                         *
                                                         * If it doesn't have
                                                         * a page with the same
                                                         * name.
                                                         *
                                                         * ---------------------
                                                         */

                                                        } else {
                                                            ?>
                                                            <span>
                                                                <?php printValue ( $segment ) ?>
                                                            </span>
                                                            <?php
                                                        }

                                                        /**
                                                         * ---------------------
                                                         *
                                                         * Display the subnodes
                                                         * of this branch.
                                                         *
                                                         * ---------------------
                                                         */

                                                        if ( $url ) {
                                                            localDisplayList ( $url, $level + 1 );
                                                        }

                                                    /**
                                                     * ---------------------
                                                     *
                                                     * Otherwise, it is the
                                                     * end of the branch.
                                                     *
                                                     * ---------------------
                                                     */

                                                    } else {
                                                        $src = $level ? $url
                                                                      : $segment;
                                                        ?>
                                                        <a href="<?php printSiteUrl (                       );
                                                                       printValue   ( 'styles/edit/' . $src ) ?>" title="Edit this CSS file" rel="nofollow">
                                                            <?php printValue ( $segment ) ?>
                                                        </a>

                                                        <small class="tools">
                                                            <a href="<?php printThemeUrl (                     );
                                                                           printValue    ( 'css/pages/' . $src ) ?>" title="View this CSS file content" rel="nofollow" target="_blank">
                                                                view
                                                            </a> &bullet; <a href="<?php printSiteUrl (                         );
                                                                                         printValue   ( 'styles/upload/' . $src ) ?>" title="Replace this CSS file with a new one" rel="nofollow">
                                                                              upload
                                                                          </a> &bullet; <a href="<?php printSiteUrl (                           );
                                                                                                       printValue   ( 'styles/download/' . $src ) ?>" title="Download this CSS file" rel="nofollow">
                                                                                            download
                                                                                        </a> &bullet; <a href="<?php printSiteUrl (                       );
                                                                                                                     printValue   ( 'styles/copy/' . $src ) ?>" title="Clone this CSS file" rel="nofollow">
                                                                                                          copy
                                                                                                      </a> &bullet; <a href="<?php printSiteUrl (                         );
                                                                                                                                   printValue   ( 'styles/delete/' . $src ) ?>" title="Delete this CSS file" rel="nofollow">
                                                                                                                        delete
                                                                                                                    </a>
                                                        </small>
                                                        <?php
                                                    }
                                                ?>
                                            </li>
                                            <?php
                                        }
                                    ?>
                                </ul>
                                <?php
                            }

                            /**
                             * ---------------------------------------------
                             *
                             * Display collected styles as a UL list.
                             *
                             * ---------------------------------------------
                             */

                            localDisplayList ( $files );
                        ?>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>styles/add" rel="nofollow" title="Add a new CSS file">
                            Add New
                        </a>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>styles/upload" rel="nofollow" title="Upload a new CSS file">
                            Upload New
                        </a>
                    </div>
                </div>
            </main>

            <footer class="footnote">
                <a class="tool" href="<?php printSiteUrl ( ) ?>pages" rel="nofollow" title="Manage pages">
                    Pages
                </a>

                <a class="tool" href="<?php printSiteUrl ( ) ?>bbcodes" rel="nofollow" title="Manage bbCode blocks">
                    bbCodes
                </a>

                <a class="tool" href="<?php printSiteUrl ( ) ?>fragments" rel="nofollow" title="Manage Page Constructor blocks">
                    Fragments
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/styles.js"></script>
    </body>
</html>
