<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template to display the Existing Pages page.
 *
 * -------------------------------------------------------------------------
 *
 * Inspired by code pen "Snake highlight" of Mikael Ainalem
 * https://codepen.io/ainalem/pen/EQXjOR
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers matching this page.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML         (   );
    sendStatus200          (   );
    sendHeaderExpires      ( 0 );
    sendHeaderLastModified (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Now we can generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html>
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">

        <title>
            Existing Pages
        </title>

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="noindex, nofollow">

        <link rel="canonical"     href="<?php printPageUrl ( ) ?>">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/pages.css">
    </head>

    <body>
        <div class="wrapper">
            <header class="success"></header>
            <aside class="error"></aside>

            <main class="content list">
                <div class="left">
                    <h1 class="title">
                        Existing Pages
                    </h1>
                    <p>To help your content manager create the site structure, this app provides the ability to edit the list of static pages.</p>

                    <a class="btn" href="<?php printSiteUrl ( ) ?>" title="Go to the home page">
                        Home Page
                    </a>
                </div>

                <div class="right">
                    <div class="form">
                        <h2>Pages intended for visitors</h2>

                        <?php
                            /**
                             * ---------------------------------------------
                             *
                             * Collect all existing pages and display them
                             * as a UL list.
                             *
                             * ---------------------------------------------
                             */

                            global $amIAdmin;
                                   $amIAdmin = helperAmIAdmin ( );
                            $files = helperCollectPages ( );
                            mimimiModule ([ 'snippets/list-pages.tpl', $files ]);
                        ?>

                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>construct" rel="nofollow" title="Add a new page using a built-in Constructor">
                            Construct New
                        </a>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>add" rel="nofollow" title="Add a new page using a built-in HTML editor">
                            Add New
                        </a>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>markup" rel="nofollow" title="Add a new page using HTML Source">
                            Mark Up New
                        </a>
                        <a class="btn compact" href="<?php printSiteUrl ( ) ?>upload" rel="nofollow" title="Upload a new page">
                            Upload New
                        </a>
                    </div>
                </div>
            </main>

            <footer class="footnote">
                <a class="tool" href="<?php printSiteUrl ( ) ?>styles" rel="nofollow" title="Manage page styles">
                    Styles
                </a>

                <a class="tool" href="<?php printSiteUrl ( ) ?>bbcodes" rel="nofollow" title="Manage bbCode blocks">
                    bbCodes
                </a>

                <a class="tool" href="<?php printSiteUrl ( ) ?>fragments" rel="nofollow" title="Manage Page Constructor blocks">
                    Fragments
                </a>
            </footer>
        </div>

        <script src="<?php printThemeUrl ( ) ?>js/pages.js"></script>
    </body>
</html>
