<?php
/**
 * -------------------------------------------------------------------------
 *
 * The module for collecting modules that working with the "database".
 *
 * -------------------------------------------------------------------------
 *
 * It implements the following properties:
 *
 *     PROTECTED  $myNodeFile  -->  to simulate a namespacing
 *
 * The following files were used below:
 *
 *     mimimi.core/NodeModule.php  -->  to import the basic module class for extending it into MyMimimiDatabase class
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'NodeModule.php' );

    class MyMimimiDatabase extends MimimiNodeModule {

        /**
         * -----------------------------------------------------------------
         *
         * Reset the namespace simulator if you want to provide an ability
         * to extend this application with child modules that perform
         * various functions.
         *
         * According to this app "database" structure, you will need at
         * least 4 child modules (bbCodes, Fragments, Pages, Styles):
         *
         *     static.pages.only/Database/Bbcodes/Bbcodes.php
         *     static.pages.only/Database/Fragments/Fragments.php
         *     static.pages.only/Database/Pages/Pages.php
         *     static.pages.only/Database/Styles/Styles.php
         *
         * -----------------------------------------------------------------
         *
         * @var    string
         * @access protected
         *
         * -----------------------------------------------------------------
         */

        protected $myNodeFile = __FILE__;
    };
