<?php
/**
 * -------------------------------------------------------------------------
 *
 * The application constants.
 *
 * -------------------------------------------------------------------------
 *
 * You can define any constants you need for modules in your application.
 * To do this, write the required constant below in this file. To avoid
 * naming conflicts, it is recommended that the constant names below begin
 * with some unique prefix, such as STATICPAGESONLY_.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Static Pages only
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Login of your administrator and MD5 hash of its password.
     *
     * ---------------------------------------------------------------------
     */

    define ( 'STATICPAGESONLY_ADMIN_LOGIN',         'admin' );
    define ( 'STATICPAGESONLY_ADMIN_PASSWORD_HASH', '202cb962ac59075b964b07152d234b70' );

    /**
     * ---------------------------------------------------------------------
     *
     * Switch that allows you to run this app in showcase mode:
     *
     *     TRUE  = to launch in demo mode (this will prevent any page from
     *             saving changes made during the demo run; all those
     *             changes will only simulate saving),
     *     FALSE = to launch in production mode.
     *
     * ---------------------------------------------------------------------
     */

    define ( 'STATICPAGESONLY_DEMO_MODE', TRUE );

    /**
     * ---------------------------------------------------------------------
     *
     * Launch mode of the SESSION module:
     *
     *     TRUE         = completely random (note that is not tamper-proof
     *                    because allows an attacker to hijack your session
     *                    simply by intercepting the session ID),
     *     FALSE        = strictly associated with the visitor's IP (it
     *                    provides good security but is not suitable for use
     *                    through a public proxy since all users using that
     *                    proxy will have the same session ID),
     *     EMPTY STRING = tied to the visitor's IP with some randomness.
     *
     * This basic module is designed to work with data stored in the user's
     * session. It is located in the "mimimi.modules/Session/Session.php"
     * file.
     *
     * ---------------------------------------------------------------------
     */

    define ( 'STATICPAGESONLY_SESSION_MODE', '' );

    /**
     * ---------------------------------------------------------------------
     *
     * Relative subpath to the directory where your site's static pages are
     * stored as TPL files. It must end with a slash. Note also that this
     * subpath is relative to the root directory of your site.
     *
     * ---------------------------------------------------------------------
     */

    define ( 'STATICPAGESONLY_STORAGE_SUBDIRECTORY', 'media/demo-posts/static.pages.only/' );

    /**
     * ---------------------------------------------------------------------
     *
     * Safety timers for various activities. They set a pause in seconds
     * that the user must wait before performing the next action of
     * a certain type.
     *
     * ---------------------------------------------------------------------
     */

    define ( 'STATICPAGESONLY_TIMEOUT_FOR_LOGIN',    20 );
    define ( 'STATICPAGESONLY_TIMEOUT_FOR_DELETE',   10 );
    define ( 'STATICPAGESONLY_TIMEOUT_FOR_EDIT',     10 );
    define ( 'STATICPAGESONLY_TIMEOUT_FOR_SETTINGS', 30 );

    /**
     * ---------------------------------------------------------------------
     *
     * License key for the CKEditor. This key should be set to "GPL" if you
     * are using the freeware version of CKEditor.
     *
     * ---------------------------------------------------------------------
     */

    define ( 'STATICPAGESONLY_CKEDITOR_KEY', 'GPL' );
