<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a STEP-1 page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Do some backend logic:
     *     load HELPER file
     *     start session
     *
     * ---------------------------------------------------------------------
     */

    mimimiModule ( 'helper.tpl' );

    startSession ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Do some security logic:
     *     if page HOME is not passed
     *         redirect to homepage
     *     remember that page STEP-1 is not passed
     *     ............. page STEP-2 is not passed
     *     ............. page STEP-3 is not passed
     *     ............. page STEP-4 is not passed
     *     send status "200 OK"
     *
     * ---------------------------------------------------------------------
     */

    if ( hasNoCheckpoint ( 'home' ) ) {
        gotoHome ( );
    }
    clearCheckpoint ( 'step1' );
    clearCheckpoint ( 'step2' );
    clearCheckpoint ( 'step3' );
    clearCheckpoint ( 'step4' );

    sendStatus200 ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Simulate a post retrieved from the database.
     *
     * ---------------------------------------------------------------------
     */

    global  $post;
            $post = [
                'title' => 'Install the MiMiMi - Directories',
                'meta'  => 'This is an installer page to choose folders for installation.',
                'h1'    => 'Choose the directories'
            ];

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?>  <?php mimimiModule ( 'blocks/header.tpl' ) ?>
    <main>
        <h1>
            <strong>Step 1 of 4</strong>
            <?php printPageH1 ( ) ?>
        </h1>
        <p>You need to select the directories where the required framework components will be installed.</p>
        <?php mimimiModule ( 'blocks/form-1.tpl' ) ?>
    </main>
    <?php mimimiModule ( 'blocks/footer.tpl' ) ?>
