<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a final page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Do some backend logic:
     *     load HELPER file
     *     start session
     *
     * ---------------------------------------------------------------------
     */

    mimimiModule ( 'helper.tpl' );

    startSession ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Do some security logic:
     *     if page STEP-4 is not passed
     *         redirect to homepage
     *     send status "200 OK"
     *
     * ---------------------------------------------------------------------
     */

    if ( hasNoCheckpoint ( 'step4' ) ) {
        gotoHome ( );
    }

    sendStatus200 ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Simulate a post retrieved from the database.
     *
     * ---------------------------------------------------------------------
     */

    global  $post;
            $post = [
                'title'    => 'Install the MiMiMi - Final',
                'h1'       => 'Installing'
            ];

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?>  <?php mimimiModule ( 'blocks/header.tpl' ) ?>
    <main>
        <h1>
            <strong>Final</strong>
            <?php printPageH1 ( ) ?>
        </h1> <?php

        /* -------------------------------------
        |                                      |
        |   Do some database logic             |
        |                                      |
        ------------------------------------- */

        $prefix = getFlashbackPrefix ( );
        if ( hasDatabase ( ) ) {

            $app->db->connect ( [
                'driver'    => getSession ( $prefix . 'databaseDriver'    ),
                'host'      => getSession ( $prefix . 'databaseHost'      ),
                'port'      => getSession ( $prefix . 'databasePort'      ),
                'user'      => getSession ( $prefix . 'databaseUser'      ),
                'password'  => getSession ( $prefix . 'databasePassword'  ),
                'name'      => getSession ( $prefix . 'databaseName'      ),
                'charset'   => getSession ( $prefix . 'databaseCharset'   ),
                'collation' => getSession ( $prefix . 'databaseCollation' )
            ] ); ?>

            <h2>Database</h2>
            <ul>
                <?php
                    $items = listInstallerModules ( );
                    foreach ( $items as $name ) {
                        $module = strtolower ( $name );
                        if ( $app->has->$module ) {
                            ?>
                            <li>Install a demo records for the <em><?php printValue ( $name ) ?></em> module <?php echo $app->$module->run ( ) ?></li>
                            <?php
                        }
                    }
                ?>
            </ul> <?php
        }

        /* -------------------------------------
        |                                      |
        |   Do some installation logic         |
        |                                      |
        ------------------------------------- */

        $modules = listCoreModules();
        $variants = listAppVariants(); ?>

        <h2>Components</h2>
        <ul>
            <li>
                Install the directory for the Core <?php

                $folder = MIMIMI_CORE_FOLDER;
                $newFolder = getCoreFolder();

                renameDirectory(
                    $folder,
                    $newFolder
                ); ?>

                <p class="success">
                    rename <span>
                               <?php printValue($folder) ?>
                           </span> to the <strong>
                                              <?php printValue($newFolder) ?>
                                          </strong>
                </p>
            </li> <?php

            /* ---------------------------------
            |                                  |
            |   ... for the Core's modules     |
            |                                  |
            --------------------------------- */

            if (hasCoreModules()) { ?>
                <li>
                    Install the directory for the Core's modules <?php

                    $folder = MIMIMI_MODULES_FOLDER;
                    $newFolder = getCoreModulesFolder(); ?>

                    <p class="success">
                        rename <span>
                                   <?php printValue ( $folder ) ?>
                               </span> to the <strong>
                                                  <?php printValue ( $newFolder ) ?>
                                              </strong>
                    </p> <?php

                    foreach ( $modules as $module ) {
                        if ( getSession ( $prefix . 'modules' . $module ) ) { ?>

                            <p class="success">
                                install module <span>
                                                   <?php printValue ( $module ) ?>
                                               </span>
                            </p> <?php

                        } else { ?>

                            <p class="remove">
                                remove <span>
                                           <?php printValue ( MIMIMI_MODULES_FOLDER . $module ) ?>
                                       </span>
                            </p> <?php

                            deleteDirectory (
                                MIMIMI_MODULES_FOLDER . $module
                            );
                        }
                    }

                    renameDirectory (
                        $folder,
                        $newFolder
                    ); ?>
                </li> <?php

            } else { ?>

                <li>
                    Remove the directory for the Core's modules <?php

                    deleteDirectory (
                        MIMIMI_MODULES_FOLDER
                    ); ?>

                    <p class="remove">
                        remove <span>
                                   <?php printValue ( MIMIMI_MODULES_FOLDER ) ?>
                               </span>
                    </p>
                </li> <?php
            }

            /* ---------------------------------
            |                                  |
            |   ... for the Installer          |
            |                                  |
            --------------------------------- */ ?>

            <li>
                Remove the directory for the Installer <?php

                ob_start ( );
                    mimimiModule ( 'blocks/footer.tpl' );
                    $footer = ob_get_contents ( );
                ob_end_clean ( );

                deleteDirectory (
                    MIMIMI_INSTALL_FOLDER
                ); ?>

                <p class="remove">
                    remove <span>
                               <?php printValue ( MIMIMI_INSTALL_FOLDER ) ?>
                           </span>
                </p>
            </li> <?php

            /* ---------------------------------
            |                                  |
            |   ... for the APP                |
            |                                  |
            --------------------------------- */

            if ( hasApp ( ) ) { ?>

                <li>
                    Install the directory for the APP <?php

                    $folder = getAppVariantFolder ( );
                    $newFolder = getAppFolder ( );

                    foreach ( $variants as $variant ) {
                        if ( $variant == $folder ) { ?>

                            <p class="success">
                                rename <span>
                                           <?php printValue ( $folder ) ?>
                                       </span> to the <strong>
                                                          <?php printValue ( $newFolder ) ?>
                                                      </strong>
                            </p> <?php

                        } else { ?>

                            <p class="remove">
                                remove <span>
                                           <?php printValue ( $variant ) ?>
                                       </span>
                            </p> <?php

                            deleteDirectory ( $variant );
                        }
                    }

                    renameDirectory (
                        $folder,
                        $newFolder
                    ); ?>

                </li> <?php

            } else { ?>

                <li>
                    Remove the directory for the APP <?php

                    foreach ( $variants as $variant ) { ?>

                        <p class="remove">
                            remove <span>
                                       <?php printValue ( $variant ) ?>
                                   </span>
                        </p> <?php

                        deleteDirectory ( $variant );
                    } ?>

                </li> <?php
            } ?>

        </ul>

        <!-- -----------------------------------
        |                                      |
        |   ... for constants                  |
        |                                      |
        ------------------------------------ -->

        <h2>Settings</h2>
        <ul>
            <li>CORE folder      <?php updateConstant ( 'MIMIMI_CORE_FOLDER',    'folderCore'                           ) ?></li>
            <li>MODULES folder   <?php updateConstant ( 'MIMIMI_MODULES_FOLDER', 'folderModules', MIMIMI_MODULES_FOLDER ) ?></li>
            <li>APP folder       <?php updateConstant ( 'MIMIMI_APP_FOLDER',     'folderApp',     MIMIMI_APP_FOLDER     ) ?></li>
            <li>INSTALLER folder <?php updateConstant ( 'MIMIMI_INSTALL_FOLDER', 'folderInstall', MIMIMI_INSTALL_FOLDER ) ?></li>
        </ul>
        <ul>
            <li>CORE theme       <?php updateConstant ( 'MIMIMI_CORE_THEME',    'themeCore',    MIMIMI_CORE_THEME    ) ?></li>
            <li>APP theme        <?php updateConstant ( 'MIMIMI_APP_THEME',     'themeApp',     MIMIMI_APP_THEME     ) ?></li>
            <li>INSTALLER theme  <?php updateConstant ( 'MIMIMI_INSTALL_THEME', 'themeInstall', MIMIMI_INSTALL_THEME ) ?></li>
        </ul>
        <ul>
            <li>DATABASE driver    <?php updateConstant ( 'MIMIMI_DATABASE_DRIVER',       'databaseDriver'                 ) ?></li>
            <li>DATABASE host      <?php updateConstant ( 'MIMIMI_DATABASE_HOST',         'databaseHost'                   ) ?></li>
            <li>DATABASE port      <?php updateConstant ( 'MIMIMI_DATABASE_PORT',         'databasePort'                   ) ?></li>
            <li>DATABASE user      <?php updateConstant ( 'MIMIMI_DATABASE_USER',         'databaseUser'                   ) ?></li>
            <li>DATABASE password  <?php updateConstant ( 'MIMIMI_DATABASE_PASSWORD',     'databasePassword', '**hidden**' ) ?></li>
            <li>DATABASE name      <?php updateConstant ( 'MIMIMI_DATABASE_NAME',         'databaseName'                   ) ?></li>
            <li>DATABASE prefix    <?php updateConstant ( 'MIMIMI_DATABASE_TABLE_PREFIX', 'databasePrefix'                 ) ?></li>
            <li>DATABASE charset   <?php updateConstant ( 'MIMIMI_DATABASE_CHARSET',      'databaseCharset'                ) ?></li>
            <li>DATABASE collation <?php updateConstant ( 'MIMIMI_DATABASE_COLLATION',    'databaseCollation'              ) ?></li>
        </ul> <?php

        /* -------------------------------------
        |                                      |
        |   Do some security logic             |
        |       > remember "HOME is not passed"|
        |       > ... STEP-1 is not passed     |
        |       > ... STEP-2 is not passed     |
        |       > ... STEP-3 is not passed     |
        |       > ... STEP-4 is not passed     |
        |                                      |
        ------------------------------------- */

        clearCheckpoint ( 'home'  );
        clearCheckpoint ( 'step1' );
        clearCheckpoint ( 'step2' );
        clearCheckpoint ( 'step3' );
        clearCheckpoint ( 'step4' ); ?>

        <h2>Installation completed!</h2>
        <nav>
            <a class="btn" href="<?php printSiteUri ( ) ?>"> Homepage &raquo; </a>
        </nav>
    </main>
    <?php echo $footer ?>
