<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering an Error404 page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Do some backend logic:
     *     load HELPER file
     *     send status "404 Not Found"
     *
     * ---------------------------------------------------------------------
     */

    mimimiModule ( 'helper.tpl' );

    sendStatus404 ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en">
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="robots" content="noindex, nofollow">
        <title>Page not found!</title>
        <link rel="shortcut icon" href="<?php printSiteUri ( ) ?>favicon.ico" type="image/ico">
        <style>
            <?php mimimiDump ( 'css/style.css' ) ?>
        </style>
    </head>
    <body>
        <header>
            <p>This is a base application to install any components of the MiMiMi package.</p>
        </header>
        <main>
            <h1>Page not found!</h1>
            <p>Oops, something went wrong! There is no such page. Please go to the home page.</p>
            <nav>
                <a class="btn" href="<?php printSiteUri ( ) ?>"> &laquo; Home </a>
            </nav>
        </main>
        <footer>
            <p>&copy; <?php echo date ( 'Y' ) ?> Installer Example</p>
            <menu>
                <a href="https://mimimi.software/" rel="nofollow">Powered by MiMiMi</a>
                <a href="https://flaticon.com/"    rel="nofollow">Icons by FlatIcon</a>
            </menu>
        </footer>
    </body>
</html>