<!DOCTYPE html>
<html lang="en">
    <head>
        <title>What to do next time?</title>
        <meta name="description" content="A plan to fix some bugs that will be discovered during the short testing of this application.">

        <!-- You can limit the list of allowed editing tools for this page to a specific name or any one (use an empty string) -->
        <meta name="editing-permission" content="editor">

        <!-- Note that this style URL must be specified relative to the "static.pages.only/Themes/css/pages" directory -->
        <link rel="stylesheet" href="default.css">
    </head>
    <body>
        <p>[insert=topmenu.tpl]</p>

        <article>
            <h1>What to do next time?</h1>
            <p>This is a pilot version of the app quickly assembled more for demonstration purposes rather than for use as a production instance. Therefore, in principle, it may contain minor bugs and typos.</p>
            <p>I don't know how much free time I will have yet. If I have enough, I will probably fix the errors I found. But for now, I will just write them down here so I don't forget.</p>

            <h4>Uncontrolled removal</h4>
            <p>This issue affects the following files:</p>
            <ul>
                <li>static.pages.only/Themes/default/dashboard/bbcodes-delete.tpl</li>
                <li>static.pages.only/Themes/default/dashboard/styles-delete.tpl</li>
            </ul>
            <p>The essence of this issue is that when we process the deletion of a file selected by an admin and are ready to start the deletion, we also need to check if this file is still in use somewhere.</p>
            <blockquote>
                <p>For example, the stylesheet file being deleted may still be in use on some page at that moment.</p>
            </blockquote>
            <blockquote>
                <p>Also, for example, the bbCode being deleted may be in use on some page.</p>
            </blockquote>
            <p>Therefore, we need to warn the administrator about the contradictory situation before the uncontrolled deletion of that file occupied by someone.</p>

            <h4>Editor style is glitchy</h4>
            <p>When you select a different style in the page editor form, you can see how the entire style changes - not only in the editing area, but also in the form elements. It shouldn't be like this. I need to consult with some talented CSS master who can tell me how to solve this problem in the most elegant way.</p>
            <p>Please compare the following screenshots:</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/what-to-do-next-time-1.png" loading="lazy" alt=""/>
                <figcaption>Let's say I select <u>default.css</u> style first</figcaption>
            </figure>
            <p>Then I change that style, for example to "bootstrap.css". Look what happened to the form elements:</p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/what-to-do-next-time-2.png" loading="lazy" alt=""/>
            </figure>
            <p>The same glitches occur in the built-in constructor.</p>

            <h5>Additionally</h5>
            <p>I would like to get rid of the bad practice of writing the <code>!important</code> flag in the following style files:</p>
            <ul>
                <li>static.pages.only/Themes/default/css/edit.css</li>
                <li>static.pages.only/Themes/default/css/login.css</li>
                <li>static.pages.only/Themes/default/css/ui.css</li>
                <li>static.pages.only/Themes/default/css/pages/*.css</li>
            </ul>
            <p>In some cases, using this flag may be justified. However, its excessive use usually indicates suboptimal use of style rules.</p>

            <h4>DOCTYPE conflict</h4>
            <p>The issue is more theoretical than practical, since it is unlikely that an administrator would store a Fragment block with the <code>&lt;!DOCTYPE ...&gt;</code> tag in the built-in Constructor's storage.</p>
            <p>This issue can be solved by modifying the following functions:</p>
            <ul>
                <li>
                    static.pages.only/Helper/Helper.php
                    <ul>
                        <li>helperEchoEditableBody()</li>
                    </ul>
                </li>
                <li>
                    static.pages.only/Themes/default/js/constructor.js
                    <ul>
                        <li>dragstartFragment()</li>
                    </ul>
                </li>
            </ul>
            <p>Currently, these functions modify that tag name to a CSS "safe_!doctype" name which is invalid.</p>

            <h4>Wishes</h4>
            <p>These wishes came to mind while testing this application:</p>
            <ol>
                <li>
                    <p><b>Add a grab functionality.</b> As you know, this application has 4 types of content, for which the following administrative functions are implemented:</p>
                    <ul>
                        <li>Edit,</li>
                        <li>Mark Up,</li>
                        <li>Construct,</li>
                        <li>Upload,</li>
                        <li>Download,</li>
                        <li>Copy,</li>
                        <li>Delete.</li>
                    </ul>
                    <p>I think it would make sense to also offer a Grab feature. So you can save fragments, style files, and even entire pages (their HTML) you found somewhere on the web that you like.</p>
                    <p>However, to avoid unauthorized grabbing, the Grab module must have a unique security label (like <code>&lt;meta name="allow-grab" content="..."/&gt;</code>) that should be inserted into the HTML code of the donor site to confirm permission to grab its content.</p>
                </li>
                <li>
                    <p><b>Add a page style for writing comics.</b> Currently this application contains the following style files:</p>
                    [insert=example-codes/list-styles.tpl]
                    <p>I thought it would be nice to have a style file like "comics.css" as well. I liked the simple layout shown in <a href="https://codepen.io/rrenula/pen/LzLXYJ" rel="nofollow noopener noreferrer" target="_blank">this</a> codepen example.</p>
                </li>
                <li>
                    <p><b>Fill the Fragment storage</b> with another Bootstrap blocks. Currently, the storage contains only these blocks:</p>
                    <ul>
                        <li>Breadcrumbs,</li>
                        <li>Features,</li>
                        <li>Jumbotrons.</li>
                    </ul>
                </li>
            </ol>
            <p>If you have any other interesting ideas for this application, please describe them to me.</p>
        <article>
    </body>
</html>
