<!DOCTYPE html>
<html lang="en">
    <head>
        <title>How to install this app?</title>
        <meta name="description" content="It is a short instruction that demonstrates how to install this package on your site.">

        <!-- You can limit the list of allowed editing tools for this page to a specific name or any one (use an empty string) -->
        <meta name="editing-permission" content="editor">

        <!-- Note that this style URL must be specified relative to the "static.pages.only/Themes/css/pages" directory -->
        <link rel="stylesheet" href="default.css">
    </head>
    <body>
        <p>[insert=topmenu.tpl]</p>

        <article>
            <h1>How to install this app?</h1>
            <p>It is a short instruction that demonstrates how to install this package on your site.</p>

            <h2>Downloading</h2>
            <ul>
                <li>First you need to download the MiMiMi installation package from its <a href="https://mimimi.software/" target="_blank">official website</a>.</li>
                <li>Then you need to extract this package to your computer.</li>
                <li>Next, copy the extracted package files to the root folder of your site.</li>
            </ul>

            <h2>Installing</h2>
            <ol>
                <li>
                    <p>Open the home page of your site in a browser. You will see the initial page for installing the package. That page looks like this.</p>
                    <figure class="image">
                        <img src="media/demo-posts/static.pages.only/how-to/install-1.png" loading="lazy" alt=""/>
                    </figure>
                </li>
                <li>
                    <p>Go to the next page of the installer. There is a drop box with application variants. You need to select "static.pages.only" there as shown in the following screenshot</p>
                    <figure class="image">
                        <img src="media/demo-posts/static.pages.only/how-to/install-2.png" loading="lazy" alt=""/>
                    </figure>
                    <blockquote>
                        <p>You may also enter a different directory name in the left input box if you want to change the default directory "mimimi.app/" for your application.</p>
                    </blockquote>
                </li>
                <li>
                    <p>Go to the next page of the installer where you should select a default theme if the app you are installing has more than one theme.</p>
                    <figure class="image">
                        <img src="media/demo-posts/static.pages.only/how-to/install-3.png" loading="lazy" alt=""/>
                    </figure>
                    <blockquote>
                        <p>You do not need to do anything here because this application has only theme named "default". Just click "Next" button.</p>
                    </blockquote>
                </li>
                <li>
                    <p>This application requires three modules only. You must select them as shown in the screenshot.</p>
                    <figure class="image">
                        <img src="media/demo-posts/static.pages.only/how-to/install-4.png" loading="lazy" alt=""/>
                    </figure>
                    <p>These modules are: Helper, Session, Url.</p>
                </li>
                <li>
                    <p>Now the installer will prompt you to configure the database.</p>
                    <figure class="image">
                        <img src="media/demo-posts/static.pages.only/how-to/install-5.png" loading="lazy" alt=""/>
                    </figure>
                    <p>You don't need to do anything here since this app does not use a classic database. Just click "Next" button to complete the installation.</p>
                    <p>That's all!</p>

                    <h5>The result will look like this</h5>
                    <figure class="image">
                        <img src="media/demo-posts/static.pages.only/how-to/install-6.png" loading="lazy" alt=""/>
                    </figure>
                </li>
            </ol>

            <h2>After installation</h2>
            <p>Your site will be running in demo mode for the first time.</p>
            <ul>
                <li>Your demo login is <b>admin</b></li>
                <li>And your demo password is <b>123</b></li>
            </ul>
            <p>However, demo mode does not allow you to make any changes to the site. You need the production mode.</p>
            <p>So to switch your site in production mode, you should manually edit the <u>STATICPAGESONLY_DEMO_MODE</u> constant defined in the <u>mimimi.app/Constants.php</u> file.</p>
            <p>After that, open your site again in the web browser, try to <a href="login" rel="nofollow">Log In</a> using your demo login and password, and go to the <a href="settings" rel="nofollow">Settings</a> page to customize the site as you wish. Also, immediately change the login/password there to a more secure one.</p>

            <h2>Removing demo pages</h2>
            <p>The package installer will install both the application itself and its demo pages and images to give you time to test it out, just as if the site was already populated with some content.</p>
            <p>After testing, you will probably want to remove all demo content at once. So to do this, you should manually remove the <u>media/demo-posts</u> directory.</p>
        <article>
    </body>
</html>
