<!DOCTYPE html>
<html lang="en">
    <head>
        <title>The Flavorful Tuscany Meetup</title>
        <meta name="description" content="We are delighted to welcome you to the annual Flavorful Tuscany Meetup.">

        <!-- You can limit the list of allowed editing tools for this page to a specific name or any one (use an empty string) -->
        <meta name="editing-permission" content="editor">

        <!-- Note that this style URL must be specified relative to the "static.pages.only/Themes/css/pages" directory -->
        <link rel="stylesheet" href="ck-demo.css">
    </head>
    <body>
        <p>[insert=topmenu.tpl]</p>

        <article>
            <h1 class="center">The Flavorful Tuscany Meetup</h1>
            <h2 class="center">Welcome letter</h2>

            <p>Dear Guest,</p>
            <p>
                We are delighted to welcome you to the annual
                <i>Flavorful Tuscany Meetup</i>. We hope you will enjoy the program
                as well as your stay at the
                <a href="http://ckeditor.com" rel="nofollow noopener noreferrer" target="_blank">Bilancino Hotel</a>.
            </p>
            <figure class="image">
                <img src="media/demo-posts/static.pages.only/demo-pages/image-4.png"
                     loading="lazy"
                     alt="Bilancino Hotel"
                     width="450"
                     height="301"/>
                <figcaption>Bilancino Hotel</figcaption>
            </figure>
            <p>Please find below the full schedule of the event.</p>

            <figure class="table">
                <table>
                    <thead>
                        <tr>
                            <th colspan="2">Saturday, July 14</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>9:30 AM - 11:30 AM</td>
                            <td>
                                <p>
                                    <strong>Americano vs. Brewed</strong>
                                    - “know your coffee” with:
                                </p>
                                <ul>
                                    <li>Giulia Orlanda</li>
                                    <li>Stefano Garau</li>
                                    <li>Giuseppe Russo</li>
                                </ul>
                            </td>
                        </tr>
                        <tr>
                            <td>1:00 PM - 3:00 PM</td>
                            <td>
                                <p>
                                    <strong>Regional delicacies of Tuscany</strong>
                                    - live cooking
                                </p>
                                <p>
                                    Incorporate the freshest ingredients 
                                    <br />
                                    with Rita Fresco
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td>5:00 PM - 8:00 PM</td>
                            <td>
                                <strong>Tuscan vineyards at a glance</strong>
                                - wine-tasting 
                                <br />
                                with Frederico Riscoli
                            </td>
                        </tr>
                    </tbody>
                </table>
            </figure>

            <blockquote>
                <p>
                    The annual Flavorful Tuscany meetups are always a culinary
                    discovery. You get the best of Tuscan flavors during an intense
                    one-day stay at one of the top hotels in the region. All the
                    sessions are led by top chefs passionate about their profession. I
                    would recommend saving the date in your calendar for this one!
                </p>

                <p>Angelina Calvino, food journalist</p>
            </blockquote>

            <p>
                Please arrive at the
                <a href="http://ckeditor.com" rel="nofollow noopener noreferrer" target="_blank">Bilancino Hotel</a>
                reception desk
                <span style="background-color: #ffecb3">at least half an hour earlier</span>
                to ensure that the registration process goes as smoothly as
                possible.
            </p>

            <p>We look forward to welcoming you to the event.</p>
            <p>
                <img src="media/demo-posts/static.pages.only/demo-pages/image-5.png"
                     loading="lazy"
                     class="image_resized"
                     alt="Victoria Valc signature"
                     width="180"/>
            </p>
            <p><strong>Victoria Valc</strong></p>
            <p><strong>Event Manager</strong></p>
            <p><strong>Bilancino Hotel</strong></p>
        <article>
    </body>
</html>
