<!DOCTYPE html>
<html lang="en">
    <head>
        <title>Carousel Template example</title>
        <meta name="description" content="Adapted version of the Carousel Template that has been extracted from Bootstrap examples.">

        <!-- You can limit the list of allowed editing tools for this page to a specific name or any one (use an empty string) -->
        <meta name="editing-permission" content="constructor">

        <!-- Note that this style URL must be specified relative to the "static.pages.only/Themes/css/pages" directory -->
        <link rel="stylesheet" href="bootstrap.css">
    </head>
    <body>
        <header data-bs-theme="dark">
            <nav class="navbar navbar-expand-md navbar-dark fixed-top bg-dark">
                <div class="container-fluid">
                    <a class="navbar-brand" href="./">
                        Carousel
                    </a>

                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse-carousel-template" aria-controls="navbarCollapse-carousel-template" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon">
                        </span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarCollapse-carousel-template">
                        <ul class="navbar-nav me-auto mb-2 mb-md-0">
                            <li class="nav-item">
                                <a class="nav-link active" aria-current="page" href="./">
                                    Home
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="toc">
                                    Table Of Contents
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link disabled" aria-disabled="true">
                                    Something
                                </a>
                            </li>
                        </ul>

                        <form class="d-flex" role="search" action="some-result-url" method="post">
                            <input type="search"
                                   name="query"
                                   required
                                   maxlength="60"
                                   placeholder="Enter a keyword..."
                                   aria-label="Search"
                                   class="form-control me-2">
                            <button class="btn btn-outline-success" type="submit">
                                Search
                            </button>
                        </form>
                    </div>
                </div>
            </nav>
        </header>

        <section class="carousel-template">

            <style hidden>
                body:has(.carousel-template) {
                    padding-top: 3rem;
                    padding-bottom: 3rem;
                    color: rgb(var(--bs-tertiary-color-rgb));
                }

                .carousel-template .bd-placeholder-img {
                    font-size: 1.125rem;
                    text-anchor: middle;
                    -webkit-user-select: none;
                    -moz-user-select: none;
                    user-select: none;
                }
                @media (min-width: 768px) {
                    .carousel-template .bd-placeholder-img-lg {
                        font-size: 3.5rem;
                    }
                }

                .carousel-template .carousel {
                    margin-bottom: 4rem;
                }

                .carousel-template .carousel-caption {
                    bottom: 3rem;
                    z-index: 10;
                }

                .carousel-template .carousel-item {
                    height: 32rem;
                }

                .carousel-template .marketing .col-lg-4 {
                    margin-bottom: 1.5rem;
                    text-align: center;
                }
                .carousel-template .marketing .col-lg-4 p {
                    margin-right: .75rem;
                    margin-left: .75rem;
                }

                .carousel-template .featurette-divider {
                    margin: 5rem 0;
                }

                .carousel-template .featurette-heading {
                    letter-spacing: -.05rem;
                }

                @media (min-width: 40em) {
                    .carousel-template .carousel-caption p {
                        margin-bottom: 1.25rem;
                        font-size: 1.25rem;
                        line-height: 1.4;
                    }

                    .carousel-template .featurette-heading {
                        font-size: 50px;
                    }
                }

                @media (min-width: 62em) {
                    .carousel-template .featurette-heading {
                        margin-top: 7rem;
                    }
                }
            </style>

            <div id="myCarousel-carousel-template" class="carousel slide mb-6" data-bs-ride="carousel">
                <div class="carousel-indicators">
                    <button type="button" data-bs-target="#myCarousel-carousel-template" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
                    <button type="button" data-bs-target="#myCarousel-carousel-template" data-bs-slide-to="1" aria-label="Slide 2"></button>
                    <button type="button" data-bs-target="#myCarousel-carousel-template" data-bs-slide-to="2" aria-label="Slide 3"></button>
                </div>

                <div class="carousel-inner">
                    <div class="carousel-item active">
                        <svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice">
                            <rect width="100%" height="100%" fill="var(--bs-secondary-color)"/>
                        </svg>
                        <div class="container">
                            <div class="carousel-caption text-start">
                                <h1>
                                    Carousel Template
                                </h1>
                                <p class="opacity-75">Some representative placeholder content for the first slide of the carousel.</p>
                                <p>
                                    <a class="btn btn-lg btn-primary" href="toc">
                                        More pages
                                    </a>
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="carousel-item">
                        <svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice">
                            <rect width="100%" height="100%" fill="var(--bs-secondary-color)"/>
                        </svg>
                        <div class="container">
                            <div class="carousel-caption">
                                <h1>
                                    Another example headline
                                </h1>
                                <p>Some representative placeholder content for the second slide of the carousel.</p>
                                <p>
                                    <a class="btn btn-lg btn-primary" href="credits">
                                        Credits
                                    </a>
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="carousel-item">
                        <svg class="bd-placeholder-img" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" preserveAspectRatio="xMidYMid slice">
                            <rect width="100%" height="100%" fill="var(--bs-secondary-color)"/>
                        </svg>
                        <div class="container">
                            <div class="carousel-caption text-end">
                                <h1>
                                    One more for good measure
                                </h1>
                                <p>Some representative placeholder content for the third slide of this carousel.</p>
                                <p>
                                    <a class="btn btn-lg btn-primary" href="./">
                                        Home Page
                                    </a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <button class="carousel-control-prev" type="button" data-bs-target="#myCarousel-carousel-template" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"/>
                    <span class="visually-hidden">
                        Previous
                    </span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#myCarousel-carousel-template" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"/>
                    <span class="visually-hidden">
                        Next
                    </span>
                </button>
            </div>

            <section class="container marketing">
                <section class="row">
                    <div class="col-lg-4">
                        <svg class="bd-placeholder-img rounded-circle" width="140" height="140" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder" preserveAspectRatio="xMidYMid slice">
                            <title>Placeholder</title>
                            <rect width="100%" height="100%" fill="var(--bs-secondary-color)"/>
                        </svg>
                        <h2 class="fw-normal">
                            Heading One
                        </h2>
                        <p>Some representative placeholder content for the three columns of text below the carousel. This is the first column.</p>
                        <p>
                            <a class="btn btn-secondary" href="./">
                                Home Page &raquo;
                            </a>
                        </p>
                    </div>

                    <div class="col-lg-4">
                        <svg class="bd-placeholder-img rounded-circle" width="140" height="140" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder" preserveAspectRatio="xMidYMid slice">
                            <title>Placeholder</title>
                            <rect width="100%" height="100%" fill="var(--bs-secondary-color)"/>
                        </svg>
                        <h2 class="fw-normal">
                            Heading Two
                        </h2>
                        <p>Another exciting bit of representative placeholder content. This time, we've moved on to the second column.</p>
                        <p>
                            <a class="btn btn-secondary" href="toc">
                                Table Of Contents &raquo;
                            </a>
                        </p>
                    </div>

                    <div class="col-lg-4">
                        <svg class="bd-placeholder-img rounded-circle" width="140" height="140" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder" preserveAspectRatio="xMidYMid slice">
                            <title>Placeholder</title>
                            <rect width="100%" height="100%" fill="var(--bs-secondary-color)"/>
                        </svg>
                        <h2 class="fw-normal">
                            Heading Three
                        </h2>
                        <p>And lastly this, the third column of representative placeholder content.</p>
                        <p>
                            <a class="btn btn-secondary" href="credits">
                                Credits &raquo;
                            </a>
                        </p>
                    </div>
                </section>

                <hr class="featurette-divider">

                <div class="row featurette">
                    <div class="col-md-7">
                        <h2 class="featurette-heading fw-normal lh-1">
                            First featurette heading.
                            <span class="text-body-secondary">It’ll blow your mind.</span>
                        </h2>
                        <p class="lead">Some great placeholder content for the first featurette here. Imagine some exciting prose here.</p>
                    </div>
                    <div class="col-md-5">
                        <svg class="bd-placeholder-img bd-placeholder-img-lg featurette-image img-fluid mx-auto" width="500" height="500" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 500x500" preserveAspectRatio="xMidYMid slice">
                            <title>Placeholder</title>
                            <rect width="100%" height="100%" fill="var(--bs-secondary-bg)"/>
                            <text x="50%" y="50%" fill="var(--bs-secondary-color)" dy=".3em">500x500</text>
                        </svg>
                    </div>
                </div>

                <hr class="featurette-divider">

                <div class="row featurette">
                    <div class="col-md-7 order-md-2">
                        <h2 class="featurette-heading fw-normal lh-1">
                            Oh yeah, it’s that good.
                            <span class="text-body-secondary">See for yourself.</span>
                        </h2>
                        <p class="lead">Another featurette? Of course. More placeholder content here to give you an idea of how this layout would work with some actual real-world content in place.</p>
                    </div>
                    <div class="col-md-5 order-md-1">
                        <svg class="bd-placeholder-img bd-placeholder-img-lg featurette-image img-fluid mx-auto" width="500" height="500" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 500x500" preserveAspectRatio="xMidYMid slice">
                            <title>Placeholder</title>
                            <rect width="100%" height="100%" fill="var(--bs-secondary-bg)"/>
                            <text x="50%" y="50%" fill="var(--bs-secondary-color)" dy=".3em">500x500</text>
                        </svg>
                    </div>
                </div>

                <hr class="featurette-divider">

                <div class="row featurette">
                    <div class="col-md-7">
                        <h2 class="featurette-heading fw-normal lh-1">
                            And lastly, this one.
                            <span class="text-body-secondary">Checkmate.</span>
                        </h2>
                        <p class="lead">And yes, this is the last block of representative placeholder content. Again, not really intended to be actually read, simply here to give you a better view of what this would look like with some actual content. Your content.</p>
                    </div>
                    <div class="col-md-5">
                        <svg class="bd-placeholder-img bd-placeholder-img-lg featurette-image img-fluid mx-auto" width="500" height="500" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 500x500" preserveAspectRatio="xMidYMid slice">
                            <title>Placeholder</title>
                            <rect width="100%" height="100%" fill="var(--bs-secondary-bg)"/>
                            <text x="50%" y="50%" fill="var(--bs-secondary-color)" dy=".3em">500x500</text>
                        </svg>
                    </div>
                </div>

                <hr class="featurette-divider">
            </section>

            <footer class="container">
                <p class="float-end">
                    <a href="./">
                        Go to Home
                    </a>
                </p>
                <p>&copy; 2017–2025 Company, Inc. &middot; <a href="toc">Privacy</a> &middot; <a href="toc">Terms</a></p>
                <div><small>* It is an adapted version of the Carousel Template that has been extracted from Bootstrap examples.</small></div>
            </footer>

            <script hidden src="static.pages.only/Themes/default/css/vendors/bootstrap.bundle-5.3.5.min.js"></script>
        </section>
    </body>
</html>
