<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the widget "Recycle Bin".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiWidgetsTrash extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Launches a checkpoint associated with this widget.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the widget URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/widgets/trash/SOME-PARAMETERS
         *                                                           └─────┬───────┘
         *                                                                 └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the checkpoint was launched successfully.
         *                           FALSE if there is no template file for this checkpoint.
         *                           FALSE if the widget URL contains no parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            global $item;
                   $item = $params;
            return $params == ''
                            ? FALSE
                            : $this->app->renderPage ( 'widgets/trash.tpl' );
        }
    };
