<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the page "Topmenu -> File -> New -> File".
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    $error     = '';
    $success   = '';
    $file      = '';
    $extension = '.' . preg_replace ( '~\|~u'                  ,
                                      ', .'                    ,
                                      helperFileExtensions ( ) );
    $screen    = 1;

    /**
     * ---------------------------------------------------------------------
     *
     * If the input form was submitted.
     *
     * ---------------------------------------------------------------------
     */

    if ( getFormInput ( 'submit' ) ) {

        /**
         * -----------------------------------------------------------------
         *
         * Get the entered file path and name.
         *
         * -----------------------------------------------------------------
         */

        $file = getFormInput ( 'file' );
        $file = mimimiSafePath ( $file, TRUE );
        if ( $file ) {

            /**
             * -------------------------------------------------------------
             *
             * It must be alphanumeric path and file name.
             *
             * -------------------------------------------------------------
             */

            if ( preg_match ( helperFilePattern ( ), $file ) ) {

                /**
                 * ---------------------------------------------------------
                 *
                 * It must be unique.
                 *
                 * ---------------------------------------------------------
                 */

                if ( ! helperHasFile ( $file ) ) {

                    /**
                     * -----------------------------------------------------
                     *
                     * Create the project file.
                     *
                     * -----------------------------------------------------
                     */

                    if ( helperHasProduction ( ) ) {
                        helperCreateFile ( $file );
                        $screen = 2;

                    /**
                     * -----------------------------------------------------
                     *
                     * Otherwise, prepare an error message.
                     *
                     * -----------------------------------------------------
                     */

                    } else {
                        $success = 'Sorry, you are currently in demo mode. Any create/add/edit/delete operation is only simulated in this mode. To see how it really works, download this package and install it on your site or localhost.';
                    }
                } else {
                    $error = 'Sorry, the current project already contains a file with the same name. Please enter another name.';
                }
            } else {
                $error = 'The path and file name can only contain alphanumeric characters, hyphens, underscores, and periods. Path segments must be separated by slashes. The file name must have a valid extension: ' . $extension . '.';
            }
        } else {
            $error = 'The File field below is required.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

    switch ( $screen ) {

        /**
         * -----------------------------------------------------------------
         *
         * On the first screen, we ask the user to enter file details.
         *
         * -----------------------------------------------------------------
         */

        case 1:
             ?>
             <form class="modal notification" action="<?php printPageUrl ( ) ?>" method="post">
                 <div class="error"  ><?php printValue ( $error   ) ?></div>
                 <div class="success"><?php printValue ( $success ) ?></div>

                 <h1>New File</h1>
                 <p>Enter a path and name where the new file will be located.</p>
                 <label>
                     <small>File</small>
                     <input type="text" name="file" value="<?php printValue ( $file ) ?>" max-length="255" required>
                     <small>Allowed extensions are: <?php printValue ( $extension ) ?>.</small>
                 </label>

                 <footer class="buttons">
                     <button class="btn" name="submit" type="submit" value="1">OK</button>
                     <button class="btn" onclick="app.closeWindow ( this )"   >CANCEL</button>
                 </footer>
             </form>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the second screen, we just redirect the user to the home page.
         *
         * -----------------------------------------------------------------
         */

        case 2:
        default:
             mimimiModule ( 'snippets/go-home.tpl' );
    }
