<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the menu item "File -> Open".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiMenuFileOpen extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the menu item "File -> Open".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            $activated = $this->app->menu->file->isActive ( );
            return [ 'open' => [ 'name'     => 'Open',
                                 'title'    => 'Opens a project or uploads a file to it.',

                                 'subitems' => [ [ 'name'     => 'Project...',
                                                   'shortcut' => 'o',
                                                   'inactive' => $activated,
                                                   'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h240l80 80h320q33 0 56.5 23.5T880-640H447l-80-80H160v480l96-320h684L837-217q-8 26-29.5 41.5T760-160H160Zm84-80h516l72-240H316l-72 240Zm0 0 72-240-72 240Zm-84-400v-80 80Z"/></svg>',
                                                   'url'      => $base,
                                                   'title'    => 'Opens a project on the server side.' ],

                                                 [ 'name'     => 'File...',
                                                   'shortcut' => 'u',
                                                   'inactive' => ! $activated,
                                                   'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M440-200h80v-167l64 64 56-57-160-160-160 160 57 56 63-63v167ZM240-80q-33 0-56.5-23.5T160-160v-640q0-33 23.5-56.5T240-880h320l240 240v480q0 33-23.5 56.5T720-80H240Zm280-520v-200H240v640h480v-440H520ZM240-800v200-200 640-640Z"/></svg>',
                                                   'url'      => $base . 'file',
                                                   'title'    => 'Uploads a local file to the current project.' ] ] ] ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/menu/file/open/
         *                           https://your.site/menu/file/open/file
         *                           https://your.site/menu/file/open/UNEXPECTED-PARAMETERS
         *                                                            └────────┬──────────┘
         *                                                                     └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the page was rendered successfully.
         *                           FALSE if there is no template file for this page.
         *                           FALSE if the menu item URL contains unexpected parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            switch ( $params ) {
                case '':     return $this->app->menu->file->isActive ( )
                                                              ? $this->app->renderNotAllowed ( )
                                                              : $this->app->renderPage ( 'file/open.tpl' );
                case 'file': return $this->app->menu->file->isActive ( )
                                                              ? $this->app->renderPage ( 'file/open-file.tpl' )
                                                              : $this->app->renderNotAllowed ( );
            }
            return FALSE;
        }
    };
