<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a channel page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app    = your application
 *     $params = entries listed by the "Channels" visual module
 *
 * -------------------------------------------------------------------------
 *
 * The first lines of this template pass the necessary headers to the user's
 * browser. To do this, routines such as "sendHeaderHTML", "sendStatus200",
 * and "stopIfHead" are used. They are implemented in the "Helper" system
 * module. It is located in the "mimimi.modules/Helper/Helper.php" file.
 *
 * The next lines generate a page content. Three routines used here are
 * "printSiteUrl", "printThemeUrl", and "printValue". They are also
 * implemented in the "Helper" module.
 *
 * -------------------------------------------------------------------------
 */

    sendHeaderHTML ( );
    sendStatus200  ( );
    stopIfHead     ( );

    $channel = reset ( $params );

?><!DOCTYPE html>
<html lang="en-US" class="channel-page">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="index, follow">
        <title>
            <?php printValue ( $channel[ 'name' ] ) ?>
        </title>
        <meta name="description"  content="<?php printValue ( $channel[ 'meta' ] ) ?>">
        <link rel="canonical"     href="<?php printPageUrl  ( ) ?>">
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
    </head>

    <body>
        <div class="page">
            <?php mimimiModule ( 'snippets/header.tpl' ) ?>
            <?php mimimiModule ( 'snippets/menu.tpl'   ) ?>

            <main class="content">
                <?php
                    if ( $params ) {
                        $params = array_reverse ( $params );
                        foreach ( $params as $entry ) {
                            ?>
                            <section class="message">
                                <?php
                                    if ( $entry[ 'image' ] ) {
                                        ?>
                                        <figure class="splash">
                                            <img src="<?php  printValue ( $entry[ 'image' ] ) ?>" alt="" loading="lazy" decoding="async">
                                        </figure>
                                        <?php
                                    }
                                ?>

                                <div class="info"
                                     data-title="<?php printValue ( $entry[ 'title'   ] ) ?>"
                                     data-time="<?php  printValue ( $entry[ 'created' ] ) ?>"
                                     ><?php

                                         if ( $entry[ 'text'          ]
                                         ||   $entry[ 'credits'       ]
                                         ||   $entry[ 'credits_label' ] ) {

                                             echo $entry[ 'text' ];
                                             ?>

                                             <a href="<?php printValue ( $entry[ 'credits' ] ) ?>"
                                                class="btn"
                                                rel="nofollow noopener noreferrer"
                                                tabindex="-1"
                                                target="_blank"><?php printValue ( $entry[ 'credits_label' ] ) ?></a>
                                             <?php
                                         }
                                     ?></div>
                            </section>
                            <?php
                        }
                    }
                ?>
            </main>

            <aside class="hint">
                <figure class="avatar">
                    <img alt="" src="<?php printValue ( $channel[ 'avatar' ] ) ?>" loading="lazy" decoding="async">
                </figure>
                <h6><?php printValue ( $channel[ 'name' ] ) ?></h6>
                <?php     echo         $channel[ 'info' ]   ?>

                <h6>To developer</h6>
                <p>If you want to learn how the <b>Channels</b> page works, please see these files:</p>
                <ul>
                    <li>
                        <u>Application.php</u>
                        <ul>
                            <li>
                                <u>mimimi.core/Website.php</u>
                                <ul>
                                    <li>
                                        <u>mimimi.core/Application.php</u>
                                        <ul>
                                            <li>
                                                <u>mimimi.core/NodeModule.php</u>
                                                <ul>
                                                    <li><u>mimimi.core/Module.php</u></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <u>mimimi.modules/Url/Url.php</u>
                                        <ul>
                                            <li><u>mimimi.core/Module.php</u></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <u>mimimi.modules/Helper/Helper.php</u>
                                        <ul>
                                            <li><u>mimimi.core/Module.php</u></li>
                                        </ul>
                                    </li>
                                    <li><u>mimimi.core/Routines.php</u></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <u>Channels/Channels.php</u>
                        <ul>
                            <li>
                                <u>mimimi.core/NodeWithTable.php</u>
                                <ul>
                                    <li>
                                        <u>mimimi.core/ModuleWithTable.php</u>
                                        <ul>
                                            <li><u>mimimi.core/Module.php</u></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <u>mimimi.modules/Db/Db.php</u>
                                        <ul>
                                            <li><u>mimimi.core/Module.php</u></li>
                                        </ul>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <u>Channels/Messages/Messages.php</u>
                        <ul>
                            <li>
                                <u>mimimi.core/ModuleWithTable.php</u>
                                <ul>
                                    <li><u>mimimi.core/Module.php</u></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <u>Themes/default/channels-page.tpl</u>
                        <ul>
                            <li><u>Themes/default/snippets/header.tpl</u></li>
                            <li><u>Themes/default/snippets/menu.tpl</u></li>
                            <li><u>Themes/default/snippets/footer.tpl</u></li>
                            <li><u>Themes/default/css/styles.css</u></li>
                            <li><u>Themes/default/js/scripts.js</u></li>
                            <li><u>Themes/default/images/favicon.ico</u></li>
                        </ul>
                    </li>
                </ul>
            </aside>

            <?php mimimiModule ( 'snippets/footer.tpl' ) ?>
        </div>
        <script src="<?php printThemeUrl ( ) ?>js/scripts.js"></script>
    </body>
</html>
