<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the searching form.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $file = 'search-list.tpl';                          // build a template filename ( see file tiny.news.feed/Themes/default/search-list.tpl )
    $ok = $app                                          // find it
          ->themes                                      // . . via THEMES module     ( see file tiny.news.feed/Themes/Themes.php -> checkFor )
          ->checkFor($file);                            // . . using this method
                                                        // -----------------
    if ( $ok ) {                                        // if template is found
        $query = $app                                   //     get the query string
                 ->viewers                              //     . . via VIEWERS module ( see file tiny.news.feed/Viewers/Viewers.php -> getQueryParam )
                 ->getQueryParam(                       //     . . using this method
                     'q'                                //         . . from this POST or GET parameter ( see the INPUT tag below named "q" )
                 );                                     //
        ?>
        <details class="search">
            <summary class="icon">
                <img src="<?php printThemeUrl() ?>images/search.svg" alt="">
            </summary>

            <form action="<?php printSiteUrl() ?>search" class="form" method="get">
                <label>
                    <input name="q" type="text" value="<?php printValue($query) ?>" maxlength="100" required>
                </label>
            </form>
        </details>
        <?php                                           //
    }                                                   //
                                                        // -----------------
