<?php
/**
 * -------------------------------------------------------------------------
 *
 * Helper for routines to be used in template files.
 *
 * -------------------------------------------------------------------------
 */

    /* =========================================================
    |                                                          |
    |   Start the visitor's session                            |
    |                                                          |
    ========================================================= */

    function startSession () {
        global $app;
        $app->has->session
              ? $app->session->run()
              : session_start();
    }

    /* =========================================================
    |                                                          |
    |   Get the session's parameter $PARAM                     |
    |                                                          |
    ========================================================= */

    function getSession ( $param, $def = '' ) {
        global $app;
        return $app->has->session
               ? $app->session->get($param, $def)
               : mimimiSession($param, $def);
    }

    /* =========================================================
    |                                                          |
    |   Set the session's parameter $PARAM                     |
    |                                                          |
    ========================================================= */

    function setSession ( $param, $value ) {
        global $app;
        if ($app->has->session) {
            $app->session->set($param, $value);
        } else {
            $_SESSION[$param] = $value;
        }
    }

    /* =========================================================
    |                                                          |
    |   Send status code "200 OK" to the user's browser        |
    |                                                          |
    ========================================================= */

    function sendStatus200 () {
        $scheme = mimimiServer(
            'SERVER_PROTOCOL',
            'HTTP/1.1'
        );
        @ header($scheme . ' 200 OK', TRUE, 200);
    }

    /* =========================================================
    |                                                          |
    |   Send status code "404 Not Found" to the user's browser |
    |                                                          |
    ========================================================= */

    function sendStatus404 () {
        $scheme = mimimiServer(
            'SERVER_PROTOCOL',
            'HTTP/1.1'
        );
        @ header($scheme . ' 404 Not Found', TRUE, 404);
    }

    /* =========================================================
    |                                                          |
    |   Register checkpoint with that $NAME                    |
    |                                                          |
    ========================================================= */

    function setCheckpoint ( $name ) {
        setSession('helperCheckpoint-' . $name, TRUE);
    }

    /* =========================================================
    |                                                          |
    |   Unregister checkpoint with that $NAME                  |
    |                                                          |
    ========================================================= */

    function clearCheckpoint ( $name ) {
        setSession('helperCheckpoint-' . $name, FALSE);
    }

    /* =========================================================
    |                                                          |
    |   Check if session has no checkpoint with that $NAME     |
    |                                                          |
    ========================================================= */

    function hasNoCheckpoint ( $name ) {
        $value = getSession('helperCheckpoint-' . $name);
        return empty($value);
    }

    /* =========================================================
    |                                                          |
    |   Get an absolute path to the site's root folder         |
    |                                                          |
    ========================================================= */

    function getRootPath () {
        return dirname(__FILE__) . '/../../../';
    }

    /* =========================================================
    |                                                          |
    |   Update a contant named $NAME with value from the       |
    |   $PARAM located in the session                          |
    |                                                          |
    ========================================================= */

    function updateConstant ( $name, $param, $def = '', $withResponse = TRUE ) {
        $response = '';
        if ($withResponse) {
            $response = '<p class="remove">' .
                            '<span>' . printValue($name, FALSE) . '</span> not found!' .
                        '</p>';
        }

        /* -------------------------------------
        |                                      |
        |   Get value of that parameter        |
        |                                      |
        ------------------------------------- */

        $prefix = getFlashbackPrefix();
        $value = getSession($prefix . $param, FALSE);
        if ($value === FALSE ||
            $value === '' && $param != 'databasePassword') {
            $value = $def;
        }
        $value = preg_replace('/[\\\\]/u', '\\\\', $value);
        $value = preg_replace('/\'/u', '\\\'', $value);

        /* -------------------------------------
        |                                      |
        |   Define a scanning plan             |
        |                                      |
        ------------------------------------- */

        $path = getRootPath();
        $plan = [ ];
        $dir = getAppFolder();
        if ($dir) {
            $plan[] = $dir . 'Config.php';
        }
        $plan[] = getCoreFolder() . 'Config.php';
        $plan[] = 'index.php';

        /* -------------------------------------
        |                                      |
        |   Scan files by plan                 |
        |                                      |
        ------------------------------------- */

        foreach ($plan as $file) {
            $handle = @ fopen($path . $file, 'rb+');
            if ($handle !== FALSE) {
                @ flock($handle, LOCK_EX);
                $data = @ fread($handle, 100000000);
                if (is_string($data)) {

                    /* -------------------------
                    |                          |
                    |   Update constant by name|
                    |                          |
                    ------------------------- */

                    $pattern = '/(define\(\'' . $name . '\',\s*\')[^\']*(\'\))/u';
                    $exists = preg_match($pattern, $data);
                    if ($exists) {
                        $new = preg_replace($pattern, '$1' . $value . '$2', $data);

                        /* ---------------------
                        |                      |
                        |   Save it to the     |
                        |   file               |
                        |                      |
                        --------------------- */

                        if ($new != $data) {
                            @ fseek($handle, 0);
                            $size = mb_strlen($new, 'UTF-8');
                            @ fwrite($handle, $new);
                            @ ftruncate($handle, $size);
                        }
                        @ fclose($handle);

                        /* ---------------------
                        |                      |
                        |   Prepare a response |
                        |                      |
                        --------------------- */

                        if ($withResponse) {
                            $response = '<p class="success">' .
                                            printValue($name, FALSE) . ' = <span>' . printValue($value, FALSE) . '</span>' .
                                        '</p>';
                        }
                        break;
                    }
                    @ fclose($handle);
                }
            }
        }
        echo $response;
    }

    /* =========================================================
    |                                                          |
    |   Get a list of the Core's modules                       |
    |                                                          |
    ========================================================= */

    function listCoreModules () {
        return mimimiFolders(MIMIMI_MODULES_FOLDER);
    }

    /* =========================================================
    |                                                          |
    |   Get a list of the Installer's modules                  |
    |                                                          |
    ========================================================= */

    function listInstallerModules () {
        $except = [
            'Db',
            'Themes'
        ];
        return mimimiFolders(
            MIMIMI_INSTALL_FOLDER,
            $except
        );
    }

    /* =========================================================
    |                                                          |
    |   Get a list of the APP variants                         |
    |                                                          |
    ========================================================= */

    function listAppVariants () {
        $except = [
            MIMIMI_CORE_FOLDER,
            MIMIMI_MODULES_FOLDER,
            MIMIMI_INSTALL_FOLDER,
            'cgi-bin',
            'media',
            'pages'
        ];
        return mimimiFolders(
            '',
            $except
        );
    }

    /* =========================================================
    |                                                          |
    |   Get a selected folder for the Core                     |
    |                                                          |
    ========================================================= */

    function getCoreFolder () {
        $prefix = getFlashbackPrefix();
        return getSession($prefix . 'folderCore');
    }

    /* =========================================================
    |                                                          |
    |   Get a selected folder for the Core's modules           |
    |                                                          |
    ========================================================= */

    function getCoreModulesFolder () {
        $prefix = getFlashbackPrefix();
        return getSession($prefix . 'folderModules');
    }

    /* =========================================================
    |                                                          |
    |   Get a selected folder for the APP                      |
    |                                                          |
    ========================================================= */

    function getAppFolder () {
        $prefix = getFlashbackPrefix();
        return getSession($prefix . 'folderApp');
    }

    /* =========================================================
    |                                                          |
    |   Get a selected folder for the APP variant              |
    |                                                          |
    ========================================================= */

    function getAppVariantFolder () {
        $prefix = getFlashbackPrefix();
        return getSession($prefix . 'folderAppVariant');
    }

    /* =========================================================
    |                                                          |
    |   Check if session has selected folder for the Core's    |
    |   modules                                                |
    |                                                          |
    ========================================================= */

    function hasCoreModules () {
        $value = getCoreModulesFolder();
        return !empty($value);
    }

    /* =========================================================
    |                                                          |
    |   Check if session has selected folder for the APP       |
    |                                                          |
    ========================================================= */

    function hasApp () {
        $value = getAppFolder();
        return !empty($value);
    }

    /* =========================================================
    |                                                          |
    |   Check if session has selected database                 |
    |                                                          |
    ========================================================= */

    function hasDatabase () {
        $prefix = getFlashbackPrefix();
        return hasCoreModules() &&
               getSession($prefix . 'modulesDb') &&
               getSession($prefix . 'databaseDriver');
    }

    /* =========================================================
    |                                                          |
    |   Rename the $DIR directory to the $NEW                  |
    |                                                          |
    ========================================================= */

    function renameDirectory ( $dir, $new ) {
        $pattern = '/[.\s\/\\\\]+$/u';
        $dir = preg_replace($pattern, '', $dir);
        if ($dir != '') {
            $new = preg_replace($pattern, '', $new);
            if ($new != '') {
                if ($new != $dir) {

                    /* -------------------------
                    |                          |
                    |   Remove old destination |
                    |                          |
                    ------------------------- */

                    if (strtolower($new) != strtolower($dir)) {
                        deleteDirectory($new);
                    }

                    /* -------------------------
                    |                          |
                    |   Rename it              |
                    |                          |
                    ------------------------- */

                    $path = getRootPath();
                    @ rename(
                        $path . $dir,
                        $path . $new
                    );
                }
            }
        }
    }

    /* =========================================================
    |                                                          |
    |   Remove the $DIR directory completely                   |
    |                                                          |
    ========================================================= */

    function deleteDirectory ( $dir ) {
        $dir = preg_replace('/[.\s\/\\\\]+$/u', '', $dir);
        if ($dir != '') {

            /* ---------------------------------
            |                                  |
            |   Remove its subdirectories      |
            |                                  |
            --------------------------------- */

            $folders = mimimiFolders($dir);
            foreach ($folders as $folder) {
                $path = $dir . '/' . $folder;
                deleteDirectory($path);
            }

            /* ---------------------------------
            |                                  |
            |   Remove its files               |
            |                                  |
            --------------------------------- */

            $path = getRootPath();
            $handle = @ opendir($path . $dir);
            if ($handle !== FALSE) {
                while (($file = readdir($handle)) !== FALSE) {
                    if (trim($file, '.') != '') {
                        @ unlink($path . $dir . '/' . $file);
                    }
                }
                closedir($handle);
            }

            /* ---------------------------------
            |                                  |
            |   Remove it                      |
            |                                  |
            --------------------------------- */

            @ rmdir($path . $dir);
        }
    }

    /* =========================================================
    |                                                          |
    |   Redirect to the home page                              |
    |                                                          |
    ========================================================= */

    function gotoHome () {
        $uri = printSiteUri(FALSE);
        mimimiStop($uri, 307);
    }

    /* =========================================================
    |                                                          |
    |   Display the website's absolute URI                     |
    |                                                          |
    ========================================================= */

    function printSiteUri ( $toDisplay = TRUE ) {
        if (!$toDisplay) {
            return mimimiSite(FALSE) .
                   mimimiRoot(FALSE);
        }
        mimimiSite();
        mimimiRoot();
    }

    /* =========================================================
    |                                                          |
    |   Display the current page's absolute URI                |
    |                                                          |
    ========================================================= */

    function printPageUri ( $toDisplay = TRUE ) {
        if (!$toDisplay) {
            return mimimiSite(FALSE) .
                   mimimiRoot(FALSE) .
                   mimimiUri(FALSE);
        }
        mimimiSite();
        mimimiRoot();
        mimimiUri();
    }

    /* =========================================================
    |                                                          |
    |   Display a $VALUE                                       |
    |                                                          |
    ========================================================= */

    function printValue ( $value, $toDisplay = TRUE ) {
        $value = htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
        if (!$toDisplay) {
            return $value;
        }
        echo $value;
    }

    /* =========================================================
    |                                                          |
    |   Display the parameter $PARAM of the page's post        |
    |   readed to the global variable $POST                    |
    |                                                          |
    ========================================================= */

    function printPageParameter ( $param, $def = '' ) {
        global $post;
        $value = isset($post[$param])
                 ? $post[$param]
                 : $def;
        echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
    }

        /* ---------------------------------- */

        function printPageTitle ( $def = 'No Post Title!' ) {
            printPageParameter('title', $def);
        }

        /* ---------------------------------- */

        function printPageMeta ( $def = '' ) {
            printPageParameter('meta', $def);
        }

        /* ---------------------------------- */

        function printPageH1 ( $def = 'No Post Name!' ) {
            printPageParameter('h1', $def);
        }

        /* ---------------------------------- */

        function printPageBody ( $def = '' ) {
            global $post;
            echo sanitizeHtml(
                     isset($post['body'])
                     ? $post['body']
                     : $def
                 );
        }

    /* =========================================================
    |                                                          |
    |   Clean up dangerous HTML tags and attributes            |
    |                                                          |
    ========================================================= */

    function sanitizeHtml ( $html, $paranoid = TRUE ) {
        $document = '|html|head|title|meta|link|body|frameset|frame';
        $template = '|template|slot|xml';
        $injection = '|script|style|iframe|object|applet|embed';
        $container = '|header|footer|nav|menu|aside|form|dialog|noindex';
        $detail = '|table|thead|tbody|tfoot|tr|th|td|details|summary';
        $anchor = $paranoid
                  ? '|a'
                  : '';
        $media = $paranoid
                 ? '|video|audio|picture|figure|figcaption|img|image|svg'
                 : '';

        /* -------------------------------------
        |                                      |
        |   Define RegExp elements             |
        |                                      |
        ------------------------------------- */

        $tag = '([!]doctype' . $document . $template . $injection . $container . $detail . $anchor . $media . ')';
        $attributes = '([\s\/][^>]*)?';
        $tagEnding = '\/\1' . $attributes;
        $something = '.*?';
        $otherTag = '(a-z[a-z0-9_]*)';

        /* -------------------------------------
        |                                      |
        |   Remove backend scripts             |
        |                                      |
        ------------------------------------- */

        $html = preg_replace('/<\?' . $something . '\?>/us', ' ', $html);
        $html = preg_replace('/<\?' . $something . '$/us', '', $html);

        /* -------------------------------------
        |                                      |
        |   Remove comments                    |
        |                                      |
        ------------------------------------- */

        $html = preg_replace('/<!--' . $something . '-->/us', ' ', $html);
        $html = preg_replace('/<!--' . $something . '$/us', '', $html);

        /* -------------------------------------
        |                                      |
        |   Remove tag pairs                   |
        |                                      |
        ------------------------------------- */

        $html = preg_replace('/<' . $tag . $attributes . '>' . $something . '<' . $tagEnding . '>/uis', ' ', $html);

        /* -------------------------------------
        |                                      |
        |   Remove single tags                 |
        |                                      |
        ------------------------------------- */

        $html = preg_replace('/<\/?' . $tag . $attributes . '>/uis', ' ', $html);

        /* -------------------------------------
        |                                      |
        |   Remove attributes of other tags    |
        |                                      |
        |   --------------------------------   |
        |                                      |
        |   TODO: Do not remove attribute      |
        |         SRC/HREF of media tags and   |
        |         anchors if no paranoid mode. |
        |                                      |
        ------------------------------------- */

        $html = preg_replace('/<(\/?)' . $otherTag . $attributes . '>/uis', '<$1$2>', $html);
        return $html;
    }

    /* =========================================================
    |                                                          |
    |   Display the value for this $NAME field declared        |
    |   in the global $FORM definition                         |
    |                                                          |
    ========================================================= */

    function printFormValue ( $name ) {
        global $form;
        if (is_array($form)) {

            /* ---------------------------------
            |                                  |
            |   Loop through defined fields    |
            |                                  |
            --------------------------------- */

            foreach ($form as $field) {
                if (!empty($field['name'])) {
                    if ($field['name'] == $name) {

                        /* ---------------------
                        |                      |
                        |   Display it         |
                        |                      |
                        --------------------- */

                        echo isset($field['value'])
                             ? htmlspecialchars(
                                   $field['value'],
                                   ENT_QUOTES,
                                   'UTF-8'
                               )
                             : '';
                        break;
                    }
                }
            }
        }
    }

    /* =========================================================
    |                                                          |
    |   Display the <option> tags for this $NAME field         |
    |   declared in the global $FORM definition                |
    |                                                          |
    ========================================================= */

    function printFormOptions ( $name ) {
        global $form;
        if (is_array($form)) {

            /* ---------------------------------
            |                                  |
            |   Loop through defined fields    |
            |                                  |
            --------------------------------- */

            foreach ($form as $field) {
                if (!empty($field['name'])) {
                    if ($field['name'] == $name) {

                        /* ---------------------
                        |                      |
                        |   Display it         |
                        |                      |
                        --------------------- */

                        if (!empty($field['options'])) {
                            if (is_array($field['options'])) {
                                $value = isset($field['value'])
                                         ? $field['value']
                                         : '';
                                foreach ($field['options'] as $option) {
                                    $option = preg_split('/\|/u', $option);
                                    $attribute1 = $value == $option[0]
                                                  ? ' selected'
                                                  : '';
                                    $attribute2 = isset($option[1])
                                                  ? ' value="' . htmlspecialchars($option[0], ENT_QUOTES, 'UTF-8') . '"'
                                                  : '';
                                    $option = isset($option[1])
                                              ? $option[1]
                                              : $option[0];
                                    echo '<option' . $attribute1 . $attribute2 . '>' .
                                             htmlspecialchars(
                                                 $option,
                                                 ENT_QUOTES,
                                                 'UTF-8'
                                             ) .
                                         '</option>';
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    /* =========================================================
    |                                                          |
    |   Display an error warning if one exists for this $NAME  |
    |   field declared in the global $FORM definition          |
    |                                                          |
    ========================================================= */

    function printFormError ( $name ) {
        global $form;
        if (is_array($form)) {

            /* ---------------------------------
            |                                  |
            |   Loop through defined fields    |
            |                                  |
            --------------------------------- */

            foreach ($form as $field) {
                if (!empty($field['name'])) {
                    if ($field['name'] == $name) {

                        /* ---------------------
                        |                      |
                        |   Display it         |
                        |                      |
                        --------------------- */

                        echo isset($field['error'])
                             ? $field['error']
                             : '';
                        break;
                    }
                }
            }
        }
    }

    /* =========================================================
    |                                                          |
    |   Display a "changed" notification if one exists for     |
    |   this $NAME field declared in the global $FORM          |
    |   definition                                             |
    |                                                          |
    ========================================================= */

    function printFormChanges ( $name ) {
        global $form;
        if (is_array($form)) {

            /* ---------------------------------
            |                                  |
            |   Loop through defined fields    |
            |                                  |
            --------------------------------- */

            foreach ($form as $field) {
                if (!empty($field['name'])) {
                    if ($field['name'] == $name) {

                        /* ---------------------
                        |                      |
                        |   Display it         |
                        |                      |
                        --------------------- */

                        echo isset($field['changed'])
                             ? $field['changed']
                             : '';
                        break;
                    }
                }
            }
        }
    }

    /* =========================================================
    |                                                          |
    |   Get a parameter's prefix for flashbacking              |
    |                                                          |
    ========================================================= */

    function getFlashbackPrefix () {
        return 'helperFlashback-';
    }

    /* =========================================================
    |                                                          |
    |   Restore the previously posted form fields and place    |
    |   their values in the $FORM definition                   |
    |                                                          |
    ========================================================= */

    function flashbackForm ( & $form ) {
        if (is_array($form)) {

            /* ---------------------------------
            |                                  |
            |   Loop through defined fields    |
            |                                  |
            --------------------------------- */

            foreach ($form as & $field) {
                if (!empty($field['name'])) {
                    if (empty($field['readonly'])) {
                        if (!empty($field['flashback'])) {
                            $name = $field['name'];
                            $def = $field['value'];

                            /* -----------------
                            |                  |
                            |   Restore the    |
                            |   previous value |
                            |                  |
                            ----------------- */

                            $value = getSession(
                                getFlashbackPrefix() . $name,
                                $def
                            );

                            /* -----------------
                            |                  |
                            |   Place back     |
                            |                  |
                            ----------------- */

                            $field['value'] = $value;
                        }
                    }
                }
            }
        }
    }

    /* =========================================================
    |                                                          |
    |   Validate a posted form by its $FORM definition         |
    |                                                          |
    ========================================================= */

    function validateForm ( & $form, $starter ) {
        $result = FALSE;
        if (is_array($form)) {

            /* ---------------------------------
            |                                  |
            |   Only if the specific $STARTER  |
            |   field is published             |
            |                                  |
            --------------------------------- */

            if (mimimiPost($starter)) {
                $result = TRUE;

                /* -----------------------------
                |                              |
                |   Loop through defined       |
                |   fields                     |
                |                              |
                ----------------------------- */

                foreach ($form as & $field) {
                    if (!empty($field['name'])) {
                        if (empty($field['readonly'])) {
                            $name = $field['name'];
                            $def = empty($field['checkbox'])
                                   ? $field['value']
                                   : '';

                            /* -----------------
                            |                  |
                            |   Get posted     |
                            |   field          |
                            |                  |
                            ----------------- */

                            $value = trim(
                                mimimiPost($name, $def)
                            );

                            /* -----------------
                            |                  |
                            |   Correct it     |
                            |                  |
                            ----------------- */

                            if (!empty($field['corrected'])) {
                                if (is_array($field['corrected'])) {
                                    foreach ($field['corrected'] as $pattern => $replacement) {
                                        $newValue = preg_replace(
                                            $pattern,
                                            $replacement,
                                            $value
                                        );
                                        if ($newValue != $value) {
                                            $field['changed'] = empty($field['changedMessage'])
                                                                ? 'Corrected by server! It is right?'
                                                                : $field['changedMessage'];
                                            $result = FALSE;
                                        }
                                        $value = $newValue;
                                    }
                                }
                            }

                            /* -----------------
                            |                  |
                            |   Save for later |
                            |   display using  |
                            |   printFormValue |
                            |   routine        |
                            |                  |
                            ----------------- */

                            $field['value'] = $value;

                            /* -----------------
                            |                  |
                            |   Check for      |
                            |   errors         |
                            |                  |
                            ----------------- */

                            if ($value == '') {
                                if (!empty($field['required'])) {
                                    $field['error'] = empty($field['requiredError'])
                                                      ? 'This field cannot be empty!'
                                                      : $field['requiredError'];
                                    $result = FALSE;
                                }
                            } else if (!empty($field['format'])) {
                                $test = preg_match(
                                    $field['format'],
                                    $value
                                );
                                if (!$test) {
                                    $field['error'] = empty($field['formatError'])
                                                      ? 'This field is incorrect!'
                                                      : $field['formatError'];
                                    $result = FALSE;
                                }
                            }

                            /* -----------------
                            |                  |
                            |   Remember for   |
                            |   the future     |
                            |                  |
                            ----------------- */

                            if (!empty($field['flashback'])) {
                                setSession(
                                    getFlashbackPrefix() . $name,
                                    $value
                                );
                            }
                        }
                    }
                }
            }
        }
        return $result;
    }
