/* =============================================================
|                                                              |
|   Some javascripts for the website's page                    |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Handling the "GDPR notice" box                         |
    |                                                          |
    ========================================================= */

    let nodeBusy = null;
    handleGDPR();

        /* -------------------------------------
        |                                      |
        |   Its handler                        |
        |                                      |
        ------------------------------------- */

        function handleGDPR () {
            let btn = document.querySelector('aside > button');
            if (btn) {
                let animationPause = 1000;
                btn.addEventListener(
                    'click',
                    function () {
                        nodeBusy = this.parentNode;
                        nodeBusy.setAttribute('class', 'busy');
                        setTimeout(
                            sendRequest_DisableAnalysis,
                            animationPause
                        );
                    },
                    false
                );
            }
        };

        /* -------------------------------------
        |                                      |
        |   Its sender                         |
        |                                      |
        ------------------------------------- */

        function sendRequest_DisableAnalysis () {
            fetch('?action=disable').then(
                function ( response ) {
                    if (nodeBusy) {
                        if (response.status == 200) {
                            response.text().then(
                                function ( txt ) {
                                    if (nodeBusy) {
                                        if (txt == 'OK') {
                                            nodeBusy.setAttribute('class', 'hidden');
                                        } else {
                                            nodeBusy.setAttribute('class', 'error');
                                        }
                                    }
                                }
                            );
                        } else {
                            nodeBusy.setAttribute('class', 'error');
                        }
                    }
                }
            ).catch(
                function () {
                    if (nodeBusy) {
                        nodeBusy.setAttribute('class', 'error');
                    }
                }
            );
        };
 