<?php
/**
 * -------------------------------------------------------------------------
 *
 * Helper for routines to be used in template files.
 *
 * -------------------------------------------------------------------------
 */

    /* =========================================================
    |                                                          |
    |   Start the visitor's session                            |
    |                                                          |
    ========================================================= */

    function startSession ( ) {
        global $app;
        $app->has->session
              ? $app->session->run ( )
              : session_start ( );
    }

    /* =========================================================
    |                                                          |
    |   Get the session's parameter $PARAM                     |
    |                                                          |
    ========================================================= */

    function getSession ( $param, $def = '' ) {
        global $app;
        return $app->has->session
                     ? $app->session->get ( $param, $def )
                     : mimimiSession      ( $param, $def );
    }

    /* =========================================================
    |                                                          |
    |   Set the session's parameter $PARAM                     |
    |                                                          |
    ========================================================= */

    function setSession ( $param, $value ) {
        global $app;
        if ( $app->has->session ) {
            $app->session->set ( $param, $value );
        } else {
            $_SESSION[ $param ] = $value;
        }
    }

    /* =========================================================
    |                                                          |
    |   Send status code "200 OK" to the user's browser        |
    |                                                          |
    ========================================================= */

    function sendStatus200 ( ) {
        $scheme = mimimiServer (
            'SERVER_PROTOCOL',
            'HTTP/1.1'
        );
        @ header ( $scheme . ' 200 OK', TRUE, 200 );
    }

    /* =========================================================
    |                                                          |
    |   Show the website's absolute URI                        |
    |                                                          |
    ========================================================= */

    function printSiteUri ( ) {
        mimimiSite ( );
        mimimiRoot ( );
    }

    /* =========================================================
    |                                                          |
    |   Show the current page's absolute URI                   |
    |                                                          |
    ========================================================= */

    function printPageUri ( ) {
        mimimiSite ( );
        mimimiRoot ( );
        mimimiUri  ( );
    }
